/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import de.redsix.pdfcompare.BlockingHandler;
import de.redsix.pdfcompare.FileUtils;
import de.redsix.pdfcompare.ImageWithDimension;
import de.redsix.pdfcompare.InThreadExecutorService;
import de.redsix.pdfcompare.PdfComparator;
import de.redsix.pdfcompare.ResourceCacheWithLimitedImages;
import de.redsix.pdfcompare.env.Environment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.io.RandomAccessStreamCache;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utilities {
    private static final Logger LOG = LoggerFactory.getLogger(Utilities.class);

    public static RandomAccessStreamCache.StreamCacheCreateFunction getMemorySettings(int bytes) throws IOException {
        return MemoryUsageSetting.setupMixed((long)((long)bytes)).setTempDir((File)FileUtils.createTempDir((String)"PdfBox").toFile()).streamCache;
    }

    public static ExecutorService blockingExecutor(String name, int coreThreads, int maxThreads, int queueCapacity, Environment environment) {
        if (environment.useParallelProcessing()) {
            return new ThreadPoolExecutor(coreThreads, maxThreads, 3L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueCapacity), new NamedThreadFactory(name), new BlockingHandler());
        }
        return new InThreadExecutorService();
    }

    public static ExecutorService blockingExecutor(String name, int threads, int queueCapacity, Environment environment) {
        if (environment.useParallelProcessing()) {
            return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(queueCapacity), new NamedThreadFactory(name), new BlockingHandler());
        }
        return new InThreadExecutorService();
    }

    public static void shutdownAndAwaitTermination(ExecutorService executor, String executorName, Environment environment) {
        Utilities.shutdownAndAwaitTermination(executor, executorName, environment.getExecutorTimeout());
    }

    public static void shutdownAndAwaitTermination(ExecutorService executor, String executorName, int executorTimeoutInSeconds) {
        if (executor != null) {
            executor.shutdown();
            try {
                TimeUnit unit = TimeUnit.SECONDS;
                if (!executor.awaitTermination(executorTimeoutInSeconds, unit)) {
                    LOG.error("Awaiting Shutdown of Executor '{}' timed out after {} {}", new Object[]{executorName, executorTimeoutInSeconds, unit});
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Awaiting Shutdown of Executor '{}' was interrupted", (Object)executorName);
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void await(CountDownLatch latch, String latchName, Environment environment) {
        try {
            int timeout = environment.getOverallTimeout();
            TimeUnit unit = TimeUnit.MINUTES;
            if (!latch.await(timeout, unit)) {
                LOG.error("Awaiting Latch '{}' timed out after {} {}", new Object[]{latchName, timeout, unit});
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Awaiting Latch '{}' was interrupted", (Object)latchName);
            Thread.currentThread().interrupt();
        }
    }

    public static int getNumberOfPages(Path document, Environment environment) throws IOException {
        try (InputStream documentIS = Files.newInputStream(document, new OpenOption[0]);){
            int n = Utilities.getNumberOfPages(documentIS, environment);
            return n;
        }
    }

    private static int getNumberOfPages(InputStream documentIS, Environment environment) throws IOException {
        try (PDDocument pdDocument = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBuffer(documentIS), (RandomAccessStreamCache.StreamCacheCreateFunction)Utilities.getMemorySettings(environment.getDocumentCacheSize()));){
            int n = pdDocument.getNumberOfPages();
            return n;
        }
    }

    public static ImageWithDimension renderPage(Path document, int page, Environment environment) throws IOException {
        try (InputStream documentIS = Files.newInputStream(document, new OpenOption[0]);){
            ImageWithDimension imageWithDimension = Utilities.renderPage(documentIS, page, environment);
            return imageWithDimension;
        }
    }

    public static ImageWithDimension renderPage(InputStream documentIS, int page, Environment environment) throws IOException {
        try (PDDocument pdDocument = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBuffer(documentIS), (RandomAccessStreamCache.StreamCacheCreateFunction)Utilities.getMemorySettings(environment.getDocumentCacheSize()));){
            if (page >= pdDocument.getNumberOfPages()) {
                throw new IllegalArgumentException("Page out of range. Last page is: " + pdDocument.getNumberOfPages());
            }
            pdDocument.setResourceCache((ResourceCache)new ResourceCacheWithLimitedImages(environment));
            PDFRenderer pdfRenderer = new PDFRenderer(pdDocument);
            ImageWithDimension imageWithDimension = PdfComparator.renderPageAsImage(pdDocument, pdfRenderer, page, environment);
            return imageWithDimension;
        }
    }

    static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = name + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

