/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare.ui;

import de.redsix.pdfcompare.PageArea;
import de.redsix.pdfcompare.ui.PositiveIntegerVerifier;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExclusionItemPanel
extends JPanel {
    public static final String INPUT_CHANGED = "input_changed";
    public static final String GOT_FOCUS = "got_focus";
    public static final String REMOVE = "remove";
    private static final PositiveIntegerVerifier VERIFIER = new PositiveIntegerVerifier();
    private static final Font LABEL_FONT = Font.decode("SansSerif-plain-10");
    private static final Color INVALID_COLOR = new Color(0xD08080);
    private JTextField page;
    private JTextField x1;
    private JTextField y1;
    private JTextField x2;
    private JTextField y2;
    private final List<ActionListener> listeners = new ArrayList<ActionListener>();
    private boolean invalid = false;
    private final Color defaultBackground = this.getBackground();

    public ExclusionItemPanel(PageArea pageArea) {
        this.init();
        this.setData(pageArea);
    }

    private void init() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(200, 45));
        this.add(this.createLabel("page", 5, 2, 30, 20));
        this.page = this.createIntField(5, 20, 30, 20);
        this.add(this.page);
        this.add(this.createLabel("x1", 40, 2, 35, 20));
        this.x1 = this.createIntField(40, 20, 35, 20);
        this.add(this.x1);
        this.add(this.createLabel("y1", 80, 2, 35, 20));
        this.y1 = this.createIntField(80, 20, 35, 20);
        this.add(this.y1);
        this.add(this.createLabel("x2", 120, 2, 35, 20));
        this.x2 = this.createIntField(120, 20, 35, 20);
        this.add(this.x2);
        this.add(this.createLabel("y2", 160, 2, 35, 20));
        this.y2 = this.createIntField(160, 20, 35, 20);
        this.add(this.y2);
        JButton deleteButton = new JButton("x");
        deleteButton.setToolTipText("delete item");
        deleteButton.setBorder(null);
        deleteButton.setBorderPainted(false);
        deleteButton.setBounds(200, 5, 12, 12);
        this.add(deleteButton);
        deleteButton.addActionListener(event -> this.notifyListeners(REMOVE));
    }

    private void setData(PageArea pageArea) {
        this.page.setText(this.toText(pageArea.getPage()));
        this.x1.setText(this.toText(pageArea.getX1()));
        this.y1.setText(this.toText(pageArea.getY1()));
        this.x2.setText(this.toText(pageArea.getX2()));
        this.y2.setText(this.toText(pageArea.getY2()));
    }

    public PageArea getData() {
        int pageValue = this.parseInt(this.page);
        int x1Value = this.parseInt(this.x1);
        int y1Value = this.parseInt(this.y1);
        int x2Value = this.parseInt(this.x2);
        int y2Value = this.parseInt(this.y2);
        boolean noPage = pageValue == -1;
        boolean noCoords = x1Value == -1 || y1Value == -1 || x2Value == -1 || y2Value == -1;
        this.setInvalid(false);
        try {
            if (noPage && noCoords) {
                return null;
            }
            if (noPage) {
                return new PageArea(x1Value, y1Value, x2Value, y2Value);
            }
            if (noCoords) {
                return new PageArea(pageValue);
            }
            return new PageArea(pageValue, x1Value, y1Value, x2Value, y2Value);
        }
        catch (IllegalArgumentException exception) {
            this.setInvalid(true);
            return null;
        }
    }

    private String toText(int value) {
        if (value < 0) {
            return "";
        }
        return "" + value;
    }

    private int parseInt(JTextField field) {
        String text = field.getText();
        if (text == null || text.trim().length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException exception) {
            return -1;
        }
    }

    private JLabel createLabel(String text, int x, int y, int width, int height) {
        JLabel pageLabel = new JLabel(text, 0);
        pageLabel.setFont(LABEL_FONT);
        pageLabel.setBounds(x, y, width, height);
        return pageLabel;
    }

    private JTextField createIntField(int x, int y, int width, int height) {
        JTextField field = new JTextField();
        field.setInputVerifier(VERIFIER);
        field.setBounds(x, y, width, height);
        field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                ExclusionItemPanel.this.notifyListeners(ExclusionItemPanel.GOT_FOCUS);
            }

            @Override
            public void focusLost(FocusEvent event) {
                ExclusionItemPanel.this.getData();
                if (!ExclusionItemPanel.this.isInvalid()) {
                    ExclusionItemPanel.this.notifyListeners(ExclusionItemPanel.INPUT_CHANGED);
                }
            }
        });
        return field;
    }

    public void setEditable(boolean editable) {
        this.page.setEditable(editable);
        this.x1.setEditable(editable);
        this.y1.setEditable(editable);
        this.x2.setEditable(editable);
        this.y2.setEditable(editable);
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
        if (invalid) {
            this.setBackground(INVALID_COLOR);
            this.setOpaque(true);
        } else {
            this.setBackground(this.defaultBackground);
            this.setOpaque(false);
        }
        this.revalidate();
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    private void notifyListeners(String action) {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(new ActionEvent(this, 0, action));
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }
}

