/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare.ui;

import de.redsix.pdfcompare.CompareResultWithExpectedAndActual;
import java.awt.image.BufferedImage;

public class ViewModel {
    private final CompareResultWithExpectedAndActual result;
    private int pageToShow = 0;
    private boolean showExpected = true;
    private final int maxPages;

    public ViewModel(CompareResultWithExpectedAndActual compareResult) {
        this.maxPages = compareResult.getNumberOfPages();
        this.result = compareResult;
    }

    public int getPageToShow() {
        return this.pageToShow;
    }

    public boolean isShowExpected() {
        return this.showExpected;
    }

    public void showExpected() {
        this.showExpected = true;
    }

    public void showActual() {
        this.showExpected = false;
    }

    public boolean decreasePage() {
        if (this.pageToShow > 0) {
            --this.pageToShow;
            return true;
        }
        return false;
    }

    public boolean increasePage() {
        if (this.pageToShow < this.maxPages) {
            ++this.pageToShow;
            return true;
        }
        return false;
    }

    public boolean setPageToShow(int pageNumber) {
        if (pageNumber < 0 || pageNumber > this.maxPages) {
            return false;
        }
        this.pageToShow = pageNumber;
        return true;
    }

    public BufferedImage getLeftImage() {
        if (this.isShowExpected()) {
            return this.result.getExpectedImage(this.getPageToShow());
        }
        return this.result.getActualImage(this.getPageToShow());
    }

    public BufferedImage getDiffImage() {
        return this.result.getDiffImage(this.getPageToShow());
    }
}

