/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.Header;

public class Datagram
extends Header {
    protected int command;
    protected int valueId;
    protected int value;

    public Datagram(long timestamp, int channel, int destinationAddress, int sourceAddress, int command, int valueId, int value) {
        super(timestamp, channel, destinationAddress, sourceAddress);
        this.command = command;
        this.valueId = valueId;
        this.value = value;
    }

    public int getCommand() {
        return this.command;
    }

    public int getValueId() {
        return this.valueId;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int getProtocolVersion() {
        return 32;
    }

    @Override
    public byte[] toLiveBuffer(byte[] _buffer, int _start, int _length) {
        int start;
        byte[] buffer;
        int liveLength = 16;
        if (_buffer == null) {
            buffer = new byte[liveLength];
            start = 0;
        } else if (_length >= liveLength) {
            buffer = _buffer;
            start = _start;
        } else {
            buffer = null;
            start = 0;
        }
        if (buffer != null) {
            buffer[start + 0] = -86;
            buffer[start + 1] = (byte)(this.destinationAddress & 0x7F);
            buffer[start + 2] = (byte)(this.destinationAddress >> 8 & 0x7F);
            buffer[start + 3] = (byte)(this.sourceAddress & 0x7F);
            buffer[start + 4] = (byte)(this.sourceAddress >> 8 & 0x7F);
            buffer[start + 5] = 32;
            buffer[start + 6] = (byte)(this.command & 0x7F);
            buffer[start + 7] = (byte)(this.command >> 8 & 0x7F);
            buffer[start + 8] = (byte)(this.valueId & 0xFF);
            buffer[start + 9] = (byte)(this.valueId >> 8 & 0xFF);
            buffer[start + 10] = (byte)(this.value & 0xFF);
            buffer[start + 11] = (byte)(this.value >> 8 & 0xFF);
            buffer[start + 12] = (byte)(this.value >> 16 & 0xFF);
            buffer[start + 13] = (byte)(this.value >> 24 & 0xFF);
            Datagram.extractSeptett(buffer, start + 8, 6, buffer, start + 8);
            Datagram.calcAndSetChecksumV0(buffer, start + 1, 14);
        }
        return buffer;
    }

    @Override
    public int getInfo() {
        int result = this.command == 2304 ? this.valueId : 0;
        return result;
    }

    @Override
    public String getId() {
        return String.format("%s_%04X_%04X", super.getId(), this.command, this.getInfo());
    }

    @Override
    public int compareTo(Header _that) {
        int result = super.compareTo(_that);
        if (result == 0) {
            Datagram that = (Datagram)_that;
            result = this.command - that.command;
            if (result == 0) {
                result = this.getInfo() - that.getInfo();
            }
        }
        return result;
    }

    public static Datagram fromLiveBuffer(byte[] buffer, int start, int length, long timestamp, int channel) {
        Datagram dgram;
        boolean valid = (buffer[start] & 0xFF) != 170 ? false : (length < 16 ? false : (!Datagram.checkMsbs(buffer, start + 1, 15) ? false : (!Datagram.calcAndCompareChecksumV0(buffer, start + 1, 14) ? false : buffer[start + 5] == 32)));
        if (valid) {
            byte[] data = new byte[6];
            Datagram.injectSeptett(buffer, start + 8, 6, data, 0);
            int destinationAddress = buffer[start + 1] & 0x7F | (buffer[start + 2] & 0x7F) << 8;
            int sourceAddress = buffer[start + 3] & 0x7F | (buffer[start + 4] & 0x7F) << 8;
            int command = buffer[start + 6] & 0x7F | (buffer[start + 7] & 0x7F) << 8;
            int valueId = data[0] & 0xFF | (data[1] & 0xFF) << 8;
            int value = data[2] & 0xFF | (data[3] & 0xFF) << 8 | (data[4] & 0xFF) << 16 | (data[5] & 0xFF) << 24;
            dgram = new Datagram(timestamp, channel, destinationAddress, sourceAddress, command, valueId, value);
        } else {
            dgram = null;
        }
        return dgram;
    }
}

