/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

public abstract class Header
implements Comparable<Header> {
    protected long timestamp;
    protected int channel;
    protected int destinationAddress;
    protected int sourceAddress;

    protected Header(long timestamp, int channel, int destinationAddress, int sourceAddress) {
        this.timestamp = timestamp;
        this.channel = channel;
        this.destinationAddress = destinationAddress;
        this.sourceAddress = sourceAddress;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getDestinationAddress() {
        return this.destinationAddress;
    }

    public int getSourceAddress() {
        return this.sourceAddress;
    }

    public abstract int getProtocolVersion();

    public abstract byte[] toLiveBuffer(byte[] var1, int var2, int var3);

    public int getInfo() {
        return 0;
    }

    public String getId() {
        return String.format("%02X_%04X_%04X_%02X", this.channel, this.destinationAddress, this.sourceAddress, this.getProtocolVersion());
    }

    @Override
    public int compareTo(Header that) {
        int result = this.channel - that.channel;
        if (result == 0) {
            result = this.destinationAddress - that.destinationAddress;
        }
        if (result == 0) {
            result = this.sourceAddress - that.sourceAddress;
        }
        if (result == 0) {
            result = this.getProtocolVersion() - that.getProtocolVersion();
        }
        return result;
    }

    public static boolean checkMsbs(byte[] buffer, int start, int length) {
        boolean valid = true;
        for (int i = 0; i < length; ++i) {
            if ((buffer[start + i] & 0x80) == 0) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public static byte calcChecksumV0(byte[] buffer, int start, int length) {
        byte checksum = 0;
        for (int i = 0; i < length; ++i) {
            checksum = (byte)(checksum + buffer[start + i]);
        }
        checksum = (byte)(255 - checksum & 0x7F);
        return checksum;
    }

    public static boolean calcAndCompareChecksumV0(byte[] buffer, int start, int length) {
        byte checksum = Header.calcChecksumV0(buffer, start, length);
        return buffer[start + length] == checksum;
    }

    public static byte calcAndSetChecksumV0(byte[] buffer, int start, int length) {
        byte checksum;
        buffer[start + length] = checksum = Header.calcChecksumV0(buffer, start, length);
        return checksum;
    }

    public static void injectSeptett(byte[] srcBuffer, int srcStart, int length, byte[] dstBuffer, int dstStart) {
        int srcIndex = srcStart;
        int dstIndex = dstStart;
        int mask = 1;
        byte septett = srcBuffer[srcStart + length];
        for (int i = 0; i < length; ++i) {
            byte b = srcBuffer[srcIndex];
            if ((septett & mask) != 0) {
                b = (byte)(b | 0x80);
            }
            dstBuffer[dstIndex] = b;
            ++srcIndex;
            ++dstIndex;
            mask <<= 1;
        }
    }

    public static void extractSeptett(byte[] srcBuffer, int srcStart, int length, byte[] dstBuffer, int dstStart) {
        int srcIndex = srcStart;
        int dstIndex = dstStart;
        int mask = 1;
        boolean septett = false;
        for (int i = 0; i < length; ++i) {
            byte b = srcBuffer[srcIndex];
            if ((b & 0x80) != 0) {
                b = (byte)(b & 0x7F);
                septett |= mask;
            }
            dstBuffer[dstIndex] = b;
            ++srcIndex;
            ++dstIndex;
            mask <<= 1;
        }
        dstBuffer[dstIndex] = (byte)(septett ? 1 : 0);
    }
}

