/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

public class LittleEndianBuffer {
    private byte[] buffer;
    private int start;
    private int length;

    public LittleEndianBuffer(int length) {
        this(new byte[length]);
    }

    public LittleEndianBuffer(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public LittleEndianBuffer(byte[] buffer, int start, int length) {
        if (start + length > buffer.length) {
            throw new Error("Buffer too small for provided offsets");
        }
        this.buffer = buffer;
        this.start = start;
        this.length = length;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    private void checkIndexRange(int index, int length) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must not be negative");
        }
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("Index must not be greater than buffer length");
        }
        if (index + length > this.length) {
            throw new IndexOutOfBoundsException("Element must not exceed buffer length");
        }
    }

    private void checkValueRange(int value, int minimum, int maximum) {
        if (value < minimum) {
            throw new Error("Value must not be less than " + minimum);
        }
        if (value > maximum) {
            throw new Error("Value must not be greater than " + maximum);
        }
    }

    public int readI8(int index) {
        this.checkIndexRange(index, 1);
        byte value = this.buffer[this.start + index];
        return value;
    }

    public void writeI8(int index, int value) {
        this.checkIndexRange(index, 1);
        this.checkValueRange(value, -128, 127);
        this.buffer[this.start + index] = (byte)value;
    }

    public int readU8(int index) {
        this.checkIndexRange(index, 1);
        int value = this.buffer[this.start + index] & 0xFF;
        return value;
    }

    public void writeU8(int index, int value) {
        this.checkIndexRange(index, 1);
        this.checkValueRange(value, 0, 255);
        this.buffer[this.start + index] = (byte)value;
    }

    public int readI16(int index) {
        this.checkIndexRange(index, 2);
        int value = this.buffer[this.start + index] & 0xFF;
        return value |= this.buffer[this.start + index + 1] << 8;
    }

    public void writeI16(int index, int value) {
        this.checkIndexRange(index, 2);
        this.checkValueRange(value, Short.MIN_VALUE, Short.MAX_VALUE);
        this.buffer[this.start + index] = (byte)value;
        this.buffer[this.start + index + 1] = (byte)(value >> 8);
    }

    public int readU16(int index) {
        this.checkIndexRange(index, 2);
        int value = this.buffer[this.start + index] & 0xFF;
        return value |= (this.buffer[this.start + index + 1] & 0xFF) << 8;
    }

    public void writeU16(int index, int value) {
        this.checkIndexRange(index, 2);
        this.checkValueRange(value, 0, 65535);
        this.buffer[this.start + index] = (byte)value;
        this.buffer[this.start + index + 1] = (byte)(value >> 8);
    }

    public int readI24(int index) {
        this.checkIndexRange(index, 3);
        int value = this.buffer[this.start + index] & 0xFF;
        value |= (this.buffer[this.start + index + 1] & 0xFF) << 8;
        return value |= this.buffer[this.start + index + 2] << 16;
    }

    public void writeI24(int index, int value) {
        this.checkIndexRange(index, 3);
        this.checkValueRange(value, -8388608, 0x7FFFFF);
        this.buffer[this.start + index] = (byte)value;
        this.buffer[this.start + index + 1] = (byte)(value >> 8);
        this.buffer[this.start + index + 2] = (byte)(value >> 16);
    }

    public int readU24(int index) {
        this.checkIndexRange(index, 3);
        int value = this.buffer[this.start + index] & 0xFF;
        value |= (this.buffer[this.start + index + 1] & 0xFF) << 8;
        return value |= (this.buffer[this.start + index + 2] & 0xFF) << 16;
    }

    public void writeU24(int index, int value) {
        this.checkIndexRange(index, 3);
        this.checkValueRange(value, 0, 0xFFFFFF);
        this.buffer[this.start + index] = (byte)value;
        this.buffer[this.start + index + 1] = (byte)(value >> 8);
        this.buffer[this.start + index + 2] = (byte)(value >> 16);
    }

    public int readI32(int index) {
        this.checkIndexRange(index, 4);
        int value = this.buffer[this.start + index] & 0xFF;
        value |= (this.buffer[this.start + index + 1] & 0xFF) << 8;
        value |= (this.buffer[this.start + index + 2] & 0xFF) << 16;
        return value |= (this.buffer[this.start + index + 3] & 0xFF) << 24;
    }

    public void writeI32(int index, int value) {
        this.checkIndexRange(index, 4);
        this.buffer[this.start + index] = (byte)value;
        this.buffer[this.start + index + 1] = (byte)(value >> 8);
        this.buffer[this.start + index + 2] = (byte)(value >> 16);
        this.buffer[this.start + index + 3] = (byte)(value >> 24);
    }
}

