/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.Datagram;
import de.resol.vbus.Header;
import de.resol.vbus.Packet;
import de.resol.vbus.Telegram;
import java.io.IOException;
import java.io.InputStream;

public class LiveInputStream {
    protected InputStream is;
    protected int channel;
    protected byte[] rxBuffer;
    protected int rxBufferLength;
    protected long rxTimestamp;

    public LiveInputStream(InputStream is, int channel) {
        this.is = is;
        this.channel = channel;
        this.rxBuffer = new byte[1024];
        this.rxBufferLength = 0;
        this.rxTimestamp = 0L;
    }

    public Header readHeader() throws IOException {
        Header header = null;
        while (this.rxBufferLength <= 0 || (header = this.readHeaderInternal()) == null) {
            if (this.rxBufferLength >= this.rxBuffer.length) continue;
            int readLength = this.is.read(this.rxBuffer, this.rxBufferLength, this.rxBuffer.length - this.rxBufferLength);
            if (readLength < 0) break;
            this.rxBufferLength += readLength;
            this.rxTimestamp = System.currentTimeMillis();
        }
        return header;
    }

    private Header readHeaderInternal() {
        Header header = null;
        int index = 0;
        while (header == null && index < this.rxBufferLength) {
            int minLength;
            int frameCount;
            if ((this.rxBuffer[index] & 0xFF) != 170) {
                ++index;
                continue;
            }
            if (index + 6 > this.rxBufferLength) break;
            if (this.rxBuffer[index + 5] == 16) {
                if (index + 10 > this.rxBufferLength) break;
                if (!Header.checkMsbs(this.rxBuffer, index + 1, 9)) {
                    ++index;
                    continue;
                }
                if (!Header.calcAndCompareChecksumV0(this.rxBuffer, index + 1, 8)) {
                    ++index;
                    continue;
                }
                frameCount = this.rxBuffer[index + 8];
                minLength = 10 + frameCount * 6;
                if (index + minLength > this.rxBufferLength) break;
                header = Packet.fromLiveBuffer(this.rxBuffer, index, minLength, this.rxTimestamp, this.channel);
                if (header != null) {
                    index += minLength;
                    continue;
                }
                ++index;
                continue;
            }
            if (this.rxBuffer[index + 5] == 32) {
                int minLength2 = 16;
                if (index + minLength2 > this.rxBufferLength) break;
                header = Datagram.fromLiveBuffer(this.rxBuffer, index, minLength2, this.rxTimestamp, this.channel);
                if (header != null) {
                    index += minLength2;
                    continue;
                }
                ++index;
                continue;
            }
            if (this.rxBuffer[index + 5] == 48) {
                if (index + 8 > this.rxBufferLength) break;
                if (!Header.checkMsbs(this.rxBuffer, index + 1, 7)) {
                    ++index;
                    continue;
                }
                if (!Header.calcAndCompareChecksumV0(this.rxBuffer, index + 1, 6)) {
                    ++index;
                    continue;
                }
                frameCount = Telegram.getFrameCountForCommand(this.rxBuffer[index + 6]);
                minLength = 8 + frameCount * 9;
                if (index + minLength > this.rxBufferLength) break;
                header = Telegram.fromLiveBuffer(this.rxBuffer, index, minLength, this.rxTimestamp, this.channel);
                if (header != null) {
                    index += minLength;
                    continue;
                }
                ++index;
                continue;
            }
            ++index;
        }
        if (index > 0) {
            int count = this.rxBufferLength - index;
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.rxBuffer[i] = this.rxBuffer[i + index];
                }
            }
            this.rxBufferLength = count;
        }
        return header;
    }
}

