/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.Header;

public class Packet
extends Header {
    protected int command;
    protected int frameCount;
    protected byte[] frameData;

    public Packet(long timestamp, int channel, int destinationAddress, int sourceAddress, int command, int frameCount, byte[] frameData) {
        super(timestamp, channel, destinationAddress, sourceAddress);
        this.command = command;
        this.frameCount = frameCount;
        this.frameData = frameData;
    }

    public int getCommand() {
        return this.command;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public byte[] getFrameData() {
        return this.frameData;
    }

    @Override
    public int getProtocolVersion() {
        return 16;
    }

    @Override
    public byte[] toLiveBuffer(byte[] _buffer, int _start, int _length) {
        int start;
        byte[] buffer;
        int liveLength = 10 + this.frameCount * 6;
        if (_buffer == null) {
            buffer = new byte[liveLength];
            start = 0;
        } else if (_length >= liveLength) {
            buffer = _buffer;
            start = _start;
        } else {
            buffer = null;
            start = 0;
        }
        if (buffer != null) {
            buffer[start + 0] = -86;
            buffer[start + 1] = (byte)(this.destinationAddress & 0x7F);
            buffer[start + 2] = (byte)(this.destinationAddress >> 8 & 0x7F);
            buffer[start + 3] = (byte)(this.sourceAddress & 0x7F);
            buffer[start + 4] = (byte)(this.sourceAddress >> 8 & 0x7F);
            buffer[start + 5] = 16;
            buffer[start + 6] = (byte)(this.command & 0x7F);
            buffer[start + 7] = (byte)(this.command >> 8 & 0x7F);
            buffer[start + 8] = (byte)(this.frameCount & 0x7F);
            Packet.calcAndSetChecksumV0(buffer, start + 1, 8);
            for (int frameIndex = 0; frameIndex < this.frameCount; ++frameIndex) {
                int srcStart = frameIndex * 4;
                int dstStart = start + 10 + frameIndex * 6;
                Packet.extractSeptett(this.frameData, srcStart, 4, buffer, dstStart);
                Packet.calcAndSetChecksumV0(buffer, dstStart, 5);
            }
        }
        return buffer;
    }

    @Override
    public String getId() {
        return String.format("%s_%04X", super.getId(), this.command);
    }

    @Override
    public int compareTo(Header _that) {
        int result = super.compareTo(_that);
        if (result == 0) {
            Packet that = (Packet)_that;
            result = this.command - that.command;
        }
        return result;
    }

    public static Packet fromLiveBuffer(byte[] buffer, int start, int length, long timestamp, int channel) {
        Packet packet;
        boolean valid;
        if ((buffer[start] & 0xFF) != 170) {
            valid = false;
        } else if (length < 10) {
            valid = false;
        } else if (!Packet.checkMsbs(buffer, start + 1, 9)) {
            valid = false;
        } else if (!Packet.calcAndCompareChecksumV0(buffer, start + 1, 8)) {
            valid = false;
        } else if (buffer[start + 5] != 16) {
            valid = false;
        } else {
            int frameCount = buffer[start + 8];
            int minLength = 10 + frameCount * 6;
            if (length < minLength) {
                valid = false;
            } else if (!Packet.checkMsbs(buffer, start + 10, minLength - 10)) {
                valid = false;
            } else {
                valid = true;
                for (int frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
                    if (Packet.calcAndCompareChecksumV0(buffer, start + 10 + frameIndex * 6, 5)) continue;
                    valid = false;
                    break;
                }
            }
        }
        if (valid) {
            int destinationAddress = buffer[start + 1] & 0x7F | (buffer[start + 2] & 0x7F) << 8;
            int sourceAddress = buffer[start + 3] & 0x7F | (buffer[start + 4] & 0x7F) << 8;
            int command = buffer[start + 6] & 0x7F | (buffer[start + 7] & 0x7F) << 8;
            int frameCount = buffer[start + 8] & 0x7F;
            byte[] frameData = new byte[frameCount * 4];
            for (int frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
                int srcStart = start + 10 + frameIndex * 6;
                int dstStart = frameIndex * 4;
                Packet.injectSeptett(buffer, srcStart, 4, frameData, dstStart);
            }
            packet = new Packet(timestamp, channel, destinationAddress, sourceAddress, command, frameCount, frameData);
        } else {
            packet = null;
        }
        return packet;
    }
}

