/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class SpecificationFile {
    static SpecificationFile defaultSpecificationFile = null;
    private int datecode;
    private ArrayList<String> texts = new ArrayList();
    private ArrayList<LocalizedText> localizedTexts = new ArrayList();
    private ArrayList<Unit> units = new ArrayList();
    private ArrayList<DeviceTemplate> deviceTemplates = new ArrayList();
    private ArrayList<PacketTemplate> packetTemplates = new ArrayList();
    private ArrayList<EnumVariant> enumVariants = new ArrayList();
    private ArrayList<Enum> enums = new ArrayList();

    public static synchronized SpecificationFile getDefaultSpecificationFile() {
        if (defaultSpecificationFile == null) {
            InputStream is = SpecificationFile.class.getResourceAsStream("vbus_specification.vsf");
            defaultSpecificationFile = SpecificationFile.fromStream(is);
        }
        return defaultSpecificationFile;
    }

    public static Language getLanguageForLocale(Locale l) {
        String localeLanguage = l.getLanguage();
        if ("en".equals(localeLanguage)) {
            return Language.En;
        }
        if ("de".equals(localeLanguage)) {
            return Language.De;
        }
        if ("fr".equals(localeLanguage)) {
            return Language.Fr;
        }
        return Language.En;
    }

    public SpecificationFile() {
        this.forgeEnumVariantsAndEnums();
    }

    public int getDatecode() {
        return this.datecode;
    }

    public String[] getTexts() {
        return this.texts.toArray(new String[this.texts.size()]);
    }

    public LocalizedText[] getLocalizedTexts() {
        return this.localizedTexts.toArray(new LocalizedText[this.localizedTexts.size()]);
    }

    public Unit[] getUnits() {
        return this.units.toArray(new Unit[this.units.size()]);
    }

    public DeviceTemplate[] getDeviceTemplates() {
        return this.deviceTemplates.toArray(new DeviceTemplate[this.deviceTemplates.size()]);
    }

    public PacketTemplate[] getPacketTemplates() {
        return this.packetTemplates.toArray(new PacketTemplate[this.packetTemplates.size()]);
    }

    public EnumVariant[] getEnumVariants() {
        return this.enumVariants.toArray(new EnumVariant[this.enumVariants.size()]);
    }

    public Enum[] getEnums() {
        return this.enums.toArray(new Enum[this.enums.size()]);
    }

    public static SpecificationFile fromStream(InputStream is) {
        try {
            int offset;
            int readLength;
            byte[] bytes = new byte[1000000];
            for (offset = 0; offset < bytes.length && (readLength = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += readLength) {
            }
            return SpecificationFile.fromBytes(bytes, 0, offset);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static SpecificationFile fromBytes(byte[] rawBytes, int offset, int length) throws VBusSpecificationFileException {
        ByteArrayView bytes = new ByteArrayView(rawBytes, offset, length);
        SpecificationFile specFile = new SpecificationFile();
        if (!bytes.checkOffset(0, 16, 1)) {
            throw new VBusSpecificationFileException(Error.InvalidFileHeader);
        }
        ByteArrayView fileHeader = bytes.sliceEntry(0, 16);
        int checksumA = fileHeader.readU16(0);
        int checksumB = fileHeader.readU16(2);
        int totalLength = fileHeader.readI32(4);
        int dataVersion = fileHeader.readI32(8);
        int specificationOffset = fileHeader.readI32(12);
        if (totalLength != length) {
            throw new VBusSpecificationFileException(Error.InvalidFileHeaderTotalLength);
        }
        if (bytes.calcCrc16(4, length - 4) != checksumA) {
            throw new VBusSpecificationFileException(Error.InvalidFileHeaderChecksumA);
        }
        if (checksumA != checksumB) {
            throw new VBusSpecificationFileException(Error.InvalidFileHeaderChecksumB);
        }
        if (dataVersion != 1) {
            throw new VBusSpecificationFileException(Error.InvalidFileHeaderDataVersion);
        }
        if (!bytes.checkOffset(specificationOffset, 44, 1)) {
            throw new VBusSpecificationFileException(Error.InvalidFileHeaderSpecificationOffset);
        }
        specFile.parseSpecificationBlock(bytes, specificationOffset);
        return specFile;
    }

    String getTextByIndex(int index) {
        return this.texts.get(index);
    }

    String getLocalizedTextByIndex(int index, Language language) {
        int textIndex;
        LocalizedText localizedText = this.localizedTexts.get(index);
        switch (language) {
            case En: {
                textIndex = localizedText.textIndexEn;
                break;
            }
            case De: {
                textIndex = localizedText.textIndexDe;
                break;
            }
            case Fr: {
                textIndex = localizedText.textIndexFr;
                break;
            }
            default: {
                textIndex = localizedText.textIndexEn;
            }
        }
        return this.getTextByIndex(textIndex);
    }

    UnitFamily getUnitFamilyById(int id) {
        UnitFamily family;
        switch (id) {
            case -1: {
                family = UnitFamily.None;
                break;
            }
            case 0: {
                family = UnitFamily.Temperature;
                break;
            }
            case 1: {
                family = UnitFamily.Energy;
                break;
            }
            case 2: {
                family = UnitFamily.VolumeFlow;
                break;
            }
            case 3: {
                family = UnitFamily.Pressure;
                break;
            }
            case 4: {
                family = UnitFamily.Volume;
                break;
            }
            case 5: {
                family = UnitFamily.Time;
                break;
            }
            case 6: {
                family = UnitFamily.Power;
                break;
            }
            default: {
                throw new java.lang.Error("Unsupported unit family ID");
            }
        }
        return family;
    }

    Unit getUnitById(int id) {
        for (Unit unit : this.units) {
            if (unit.unitId != id) continue;
            return unit;
        }
        throw new java.lang.Error("Unsupported unit ID");
    }

    Type getTypeById(int id) {
        Type type;
        switch (id) {
            case 1: {
                type = Type.Number;
                break;
            }
            case 3: {
                type = Type.Time;
                break;
            }
            case 4: {
                type = Type.WeekTime;
                break;
            }
            case 5: {
                type = Type.DateTime;
                break;
            }
            default: {
                throw new java.lang.Error("Unsupported type ID");
            }
        }
        return type;
    }

    DeviceTemplate findDeviceTemplate(int selfAddress, int peerAddress) {
        for (DeviceTemplate deviceTemplate : this.deviceTemplates) {
            if (((deviceTemplate.selfAddress ^ selfAddress) & deviceTemplate.selfMask) != 0 || ((deviceTemplate.peerAddress ^ peerAddress) & deviceTemplate.peerMask) != 0) continue;
            return deviceTemplate;
        }
        return null;
    }

    PacketTemplate findPacketTemplate(int destinationAddress, int sourceAddress, int command) {
        for (PacketTemplate packetTemplate : this.packetTemplates) {
            if (((packetTemplate.destinationAddress ^ destinationAddress) & packetTemplate.destinationMask) != 0 || ((packetTemplate.sourceAddress ^ sourceAddress) & packetTemplate.sourceMask) != 0 || packetTemplate.command != command) continue;
            return packetTemplate;
        }
        return null;
    }

    Enum getEnumById(int id) {
        if (id == 0) {
            return null;
        }
        for (Enum e : this.enums) {
            if (e.enumId != id) continue;
            return e;
        }
        throw new java.lang.Error("Unsupported enum ID");
    }

    private boolean checkTextIndex(int index) {
        return index >= 0 && index < this.texts.size();
    }

    private boolean checkLocalizedTextIndex(int index) {
        return index >= 0 && index < this.localizedTexts.size();
    }

    private boolean checkUnitFamilyId(int id) {
        return id >= -1 && id <= 6;
    }

    private boolean checkUnitId(int id) {
        for (Unit unit : this.units) {
            if (unit.unitId != id) continue;
            return true;
        }
        return false;
    }

    private boolean checkTypeId(int id) {
        switch (id) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private void parseSpecificationBlock(ByteArrayView bytes, int specificationOffset) throws VBusSpecificationFileException {
        int index;
        ByteArrayView block = bytes.sliceEntry(specificationOffset, 44);
        int datecode = block.readI32(0);
        int textCount = block.readI32(4);
        int textTableOffset = block.readI32(8);
        int localizedTextCount = block.readI32(12);
        int localizedTextTableOffset = block.readI32(16);
        int unitCount = block.readI32(20);
        int unitTableOffset = block.readI32(24);
        int deviceTemplateCount = block.readI32(28);
        int deviceTemplateTableOffset = block.readI32(32);
        int packetTemplateCount = block.readI32(36);
        int packetTemplateTableOffset = block.readI32(40);
        if (!bytes.checkOffset(textTableOffset, 4, textCount)) {
            throw new VBusSpecificationFileException(Error.InvalidSpecificationTextTable);
        }
        if (!bytes.checkOffset(localizedTextTableOffset, 12, localizedTextCount)) {
            throw new VBusSpecificationFileException(Error.InvalidSpecificationLocalizedTextTable);
        }
        if (!bytes.checkOffset(unitTableOffset, 16, unitCount)) {
            throw new VBusSpecificationFileException(Error.InvalidSpecificationUnitTable);
        }
        if (!bytes.checkOffset(deviceTemplateTableOffset, 12, deviceTemplateCount)) {
            throw new VBusSpecificationFileException(Error.InvalidSpecificationDeviceTemplateTable);
        }
        if (!bytes.checkOffset(packetTemplateTableOffset, 20, packetTemplateCount)) {
            throw new VBusSpecificationFileException(Error.InvalidSpecificationPacketTemplateTable);
        }
        this.datecode = datecode;
        for (index = 0; index < textCount; ++index) {
            String text = this.parseTextBlock(bytes, textTableOffset, index);
            this.texts.add(text);
        }
        for (index = 0; index < localizedTextCount; ++index) {
            LocalizedText localizedText = this.parseLocalizedTextBlock(bytes, localizedTextTableOffset, index);
            this.localizedTexts.add(localizedText);
        }
        for (index = 0; index < unitCount; ++index) {
            Unit unit = this.parseUnitBlock(bytes, unitTableOffset, index);
            this.units.add(unit);
        }
        for (index = 0; index < deviceTemplateCount; ++index) {
            DeviceTemplate deviceTemplate = this.parseDeviceTemplateBlock(bytes, deviceTemplateTableOffset, index);
            this.deviceTemplates.add(deviceTemplate);
        }
        for (index = 0; index < packetTemplateCount; ++index) {
            PacketTemplate packetTemplate = this.parsePacketTemplateBlock(bytes, packetTemplateTableOffset, index);
            this.packetTemplates.add(packetTemplate);
        }
    }

    private String parseTextBlock(ByteArrayView bytes, int offset, int index) throws VBusSpecificationFileException {
        ByteArrayView block = bytes.sliceTableEntry(offset, 4, index);
        int stringOffset = block.readI32(0);
        if (!bytes.checkOffset(stringOffset, 1, 1)) {
            throw new VBusSpecificationFileException(Error.InvalidTextStringOffset);
        }
        int stringEnd = stringOffset;
        while (bytes.checkOffset(stringEnd, 1, 1) && bytes.readU8(stringEnd) != 0) {
            ++stringEnd;
        }
        try {
            return new String(bytes.bytes, stringOffset, stringEnd - stringOffset, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new VBusSpecificationFileException(Error.InvalidTextContent);
        }
    }

    private LocalizedText parseLocalizedTextBlock(ByteArrayView bytes, int offset, int index) throws VBusSpecificationFileException {
        ByteArrayView block = bytes.sliceTableEntry(offset, 12, index);
        int textIndexEn = block.readI32(0);
        int textIndexDe = block.readI32(4);
        int textIndexFr = block.readI32(8);
        if (!this.checkTextIndex(textIndexEn)) {
            throw new VBusSpecificationFileException(Error.InvalidLocalizedTextTextIndexEn);
        }
        if (!this.checkTextIndex(textIndexDe)) {
            throw new VBusSpecificationFileException(Error.InvalidLocalizedTextTextIndexDe);
        }
        if (!this.checkTextIndex(textIndexFr)) {
            throw new VBusSpecificationFileException(Error.InvalidLocalizedTextTextIndexFr);
        }
        LocalizedText localizedText = new LocalizedText();
        localizedText.textIndexEn = textIndexEn;
        localizedText.textIndexDe = textIndexDe;
        localizedText.textIndexFr = textIndexFr;
        return localizedText;
    }

    private Unit parseUnitBlock(ByteArrayView bytes, int offset, int index) throws VBusSpecificationFileException {
        ByteArrayView block = bytes.sliceTableEntry(offset, 16, index);
        int unitId = block.readI32(0);
        int unitFamilyId = block.readI32(4);
        int unitCodeTextIndex = block.readI32(8);
        int unitTextTextIndex = block.readI32(12);
        if (!this.checkUnitFamilyId(unitFamilyId)) {
            throw new VBusSpecificationFileException(Error.InvalidUnitUnitFamilyId);
        }
        if (!this.checkTextIndex(unitCodeTextIndex)) {
            throw new VBusSpecificationFileException(Error.InvalidUnitUnitCodeTextIndex);
        }
        if (!this.checkTextIndex(unitTextTextIndex)) {
            throw new VBusSpecificationFileException(Error.InvalidUnitUnitTextTextIndex);
        }
        Unit unit = new Unit();
        unit.unitId = unitId;
        unit.unitFamilyId = unitFamilyId;
        unit.unitCodeTextIndex = unitCodeTextIndex;
        unit.unitTextTextIndex = unitTextTextIndex;
        return unit;
    }

    private DeviceTemplate parseDeviceTemplateBlock(ByteArrayView bytes, int offset, int index) throws VBusSpecificationFileException {
        ByteArrayView block = bytes.sliceTableEntry(offset, 12, index);
        int selfAddress = block.readU16(0);
        int selfMask = block.readU16(2);
        int peerAddress = block.readU16(4);
        int peerMask = block.readU16(6);
        int nameLocalizedTextIndex = block.readI32(8);
        if (!this.checkLocalizedTextIndex(nameLocalizedTextIndex)) {
            throw new VBusSpecificationFileException(Error.InvalidDeviceTemplateNameLocalizedTextIndex);
        }
        DeviceTemplate deviceTemplate = new DeviceTemplate();
        deviceTemplate.selfAddress = selfAddress;
        deviceTemplate.selfMask = selfMask;
        deviceTemplate.peerAddress = peerAddress;
        deviceTemplate.peerMask = peerMask;
        deviceTemplate.nameLocalizedTextIndex = nameLocalizedTextIndex;
        return deviceTemplate;
    }

    private PacketTemplate parsePacketTemplateBlock(ByteArrayView bytes, int offset, int ptIndex) throws VBusSpecificationFileException {
        ByteArrayView block = bytes.sliceTableEntry(offset, 20, ptIndex);
        int destinationAddress = block.readU16(0);
        int destinationMask = block.readU16(2);
        int sourceAddress = block.readU16(4);
        int sourceMask = block.readU16(6);
        int command = block.readU16(8);
        int fieldCount = block.readI32(12);
        int fieldTableOffset = block.readI32(16);
        if (!bytes.checkOffset(fieldTableOffset, 28, fieldCount)) {
            throw new VBusSpecificationFileException(Error.InvalidPacketTemplateFieldTable);
        }
        PacketTemplate packetTemplate = new PacketTemplate();
        packetTemplate.destinationAddress = destinationAddress;
        packetTemplate.destinationMask = destinationMask;
        packetTemplate.sourceAddress = sourceAddress;
        packetTemplate.sourceMask = sourceMask;
        packetTemplate.command = command;
        for (int index = 0; index < fieldCount; ++index) {
            PacketTemplateField field = this.parsePacketTemplateFieldBlock(bytes, fieldTableOffset, index);
            this.forgeEnumForPacketTemplateField(packetTemplate, field);
            packetTemplate.fields.add(field);
        }
        return packetTemplate;
    }

    private PacketTemplateField parsePacketTemplateFieldBlock(ByteArrayView bytes, int offset, int ptfIndex) throws VBusSpecificationFileException {
        ByteArrayView block = bytes.sliceTableEntry(offset, 28, ptfIndex);
        int idTextIndex = block.readI32(0);
        int nameLocalizedTextIndex = block.readI32(4);
        int unitId = block.readI32(8);
        int precision = block.readI32(12);
        int typeId = block.readI32(16);
        int partCount = block.readI32(20);
        int partTableOffset = block.readI32(24);
        if (!this.checkTextIndex(idTextIndex)) {
            throw new VBusSpecificationFileException(Error.InvalidPacketTemplateFieldIdTextIndex);
        }
        if (!this.checkLocalizedTextIndex(nameLocalizedTextIndex)) {
            throw new VBusSpecificationFileException(Error.InvalidPacketTemplateFieldNameLocalizedTextIndex);
        }
        if (!this.checkUnitId(unitId)) {
            throw new VBusSpecificationFileException(Error.InvalidPacketTemplateFieldUnitId);
        }
        if (!this.checkTypeId(typeId)) {
            throw new VBusSpecificationFileException(Error.InvalidPacketTemplateFieldTypeId);
        }
        if (!bytes.checkOffset(partTableOffset, 16, partCount)) {
            throw new VBusSpecificationFileException(Error.InvalidPacketTemplateFieldPartTable);
        }
        PacketTemplateField field = new PacketTemplateField();
        field.idTextIndex = idTextIndex;
        field.nameLocalizedTextIndex = nameLocalizedTextIndex;
        field.unitId = unitId;
        field.precision = precision;
        field.typeId = typeId;
        for (int index = 0; index < partCount; ++index) {
            PacketTemplateFieldPart part = this.parsePacketTemplateFieldPartBlock(bytes, partTableOffset, index);
            field.parts.add(part);
        }
        return field;
    }

    private PacketTemplateFieldPart parsePacketTemplateFieldPartBlock(ByteArrayView bytes, int offset, int index) {
        ByteArrayView block = bytes.sliceTableEntry(offset, 16, index);
        int dataOffset = block.readI32(0);
        int bitPos = block.readU8(4);
        int mask = block.readU8(5);
        boolean isSigned = block.readU8(6) != 0;
        long factor = block.readI64(8);
        PacketTemplateFieldPart part = new PacketTemplateFieldPart();
        part.offset = dataOffset;
        part.bitPos = bitPos;
        part.mask = mask;
        part.isSigned = isSigned;
        part.factor = factor;
        return part;
    }

    private EnumVariant forgeEnumVariant(String idCode, String textEn, String textDe) {
        EnumVariant enumVariant = new EnumVariant(this.enumVariants.size(), idCode, textEn, textDe, textEn);
        this.enumVariants.add(enumVariant);
        return enumVariant;
    }

    private Enum forgeEnum(int enumId, long[] values, EnumVariant[] variants) {
        if (values.length != variants.length) {
            throw new java.lang.Error("Enum values and variants must match");
        }
        for (int i = 1; i < values.length; ++i) {
            if (values[i - 1] < values[i]) continue;
            throw new java.lang.Error("Enum values must be sorted and unique");
        }
        Enum enum_ = new Enum(enumId, values, variants);
        this.enums.add(enum_);
        return enum_;
    }

    private void forgeEnumVariantsAndEnums() {
        EnumVariant evFree = this.forgeEnumVariant("Free", "Free", "Frei");
        EnumVariant evRuntime = this.forgeEnumVariant("Runtime", "Runtime", "Laufzeit");
        EnumVariant evDeactivated = this.forgeEnumVariant("Deactivated", "Deactivated", "Deaktiviert");
        EnumVariant evDefective = this.forgeEnumVariant("Defective", "Defective", "Defekt");
        EnumVariant evAutoAdjustment = this.forgeEnumVariant("AutoAdjustment", "Auto adjust.", "Autojust.");
        EnumVariant evRthOff = this.forgeEnumVariant("RoomThermostatOff", "RTH off", "RTH aus");
        EnumVariant evChimneySweeper = this.forgeEnumVariant("ChimneySweeper", "Chimney sw.", "Schornsteinfeger");
        EnumVariant evDhwPriority = this.forgeEnumVariant("DhwPriority", "DHW priority", "BW-Vorrang");
        EnumVariant evAntifreeze = this.forgeEnumVariant("Antifreeze", "Antifreeze", "Frostschutz");
        EnumVariant evParty = this.forgeEnumVariant("Party", "Party", "Party");
        EnumVariant evSummer = this.forgeEnumVariant("Summer", "Summer", "Sommer");
        EnumVariant evRemoteControlOff = this.forgeEnumVariant("RemoteControlOff", "RC off", "FV aus");
        EnumVariant evHeatingCircuitOff = this.forgeEnumVariant("HeatingCircuitOff", "HC off", "HK aus");
        EnumVariant evNightOperation = this.forgeEnumVariant("NightOperation", "Night oper.", "Nachtbetr.");
        EnumVariant evDayOperation = this.forgeEnumVariant("DayOperation", "Day oper.", "Tagbetr.");
        EnumVariant evHoliday = this.forgeEnumVariant("Holiday", "Holiday", "Urlaub");
        EnumVariant evScreed = this.forgeEnumVariant("Screed", "Screed", "Estrich");
        EnumVariant evBlockingProtection = this.forgeEnumVariant("BlockingProtection", "Blocking protection", "Blockierschutz");
        EnumVariant evCooling = this.forgeEnumVariant("Cooling", "Cooling", "K\u00fchlung");
        EnumVariant evHeatDump = this.forgeEnumVariant("HeatDump", "Heat dump", "\u00dcberw\u00e4rmeabfuhr");
        EnumVariant evBreak = this.forgeEnumVariant("Break", "Break", "Pause");
        EnumVariant evOkay = this.forgeEnumVariant("Okay", "Okay", "Okay");
        EnumVariant evError = this.forgeEnumVariant("Error", "Error", "Fehler");
        this.forgeEnum(-1610152515, new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L}, new EnumVariant[]{evFree, evRuntime, evDeactivated, evDefective, evAutoAdjustment, evRthOff, evChimneySweeper, evDhwPriority, evAntifreeze, evParty, evSummer, evRemoteControlOff, evHeatingCircuitOff, evNightOperation, evDayOperation, evHoliday, evScreed, evBlockingProtection, evCooling, evHeatDump, evBreak});
        this.forgeEnum(1400772858, new long[]{0L, 1L}, new EnumVariant[]{evOkay, evError});
    }

    private void forgeEnumForPacketTemplateField(PacketTemplate pt, PacketTemplateField ptf) {
        if (pt.destinationAddress == 16 && pt.destinationMask == 65535 && pt.sourceAddress == 32273 && pt.sourceMask == 65535 && pt.command == 256) {
            if (ptf.parts.size() == 1) {
                PacketTemplateFieldPart part0 = ptf.parts.get(0);
                if (part0.offset >= 96 && part0.offset < 100) {
                    ptf.enumId = 1400772858;
                }
            }
        } else if (pt.destinationAddress == 16 && pt.destinationMask == 65535 && pt.sourceAddress == 32288 && pt.sourceMask == 65520 && pt.command == 256 && this.getTextByIndex(ptf.idTextIndex).equals("002_1_0")) {
            ptf.enumId = -1610152515;
        }
    }

    public static class VBusSpecificationFileException
    extends Exception {
        public VBusSpecificationFileException(Error error) {
            super(error.toString());
        }
    }

    static class ByteArrayView {
        byte[] bytes;
        int offset;
        int length;
        final int[] crc16Table = new int[]{0, 4489, 8978, 12955, 17956, 22445, 25910, 29887, 35912, 40385, 44890, 48851, 51820, 56293, 59774, 63735, 4225, 264, 13203, 8730, 22181, 18220, 30135, 25662, 40137, 36160, 49115, 44626, 56045, 52068, 63999, 59510, 8450, 12427, 528, 5017, 26406, 30383, 17460, 21949, 44362, 48323, 36440, 40913, 60270, 64231, 51324, 55797, 12675, 8202, 4753, 792, 30631, 26158, 21685, 17724, 48587, 44098, 40665, 36688, 64495, 60006, 55549, 51572, 16900, 21389, 24854, 28831, 1056, 5545, 10034, 14011, 52812, 57285, 60766, 64727, 34920, 39393, 43898, 47859, 21125, 17164, 29079, 24606, 5281, 1320, 14259, 9786, 57037, 53060, 64991, 60502, 39145, 35168, 48123, 43634, 25350, 29327, 16404, 20893, 9506, 13483, 1584, 6073, 61262, 65223, 52316, 56789, 43370, 47331, 35448, 39921, 29575, 25102, 20629, 16668, 13731, 9258, 5809, 1848, 65487, 60998, 56541, 52564, 47595, 43106, 39673, 35696, 33800, 38273, 42778, 46739, 49708, 54181, 57662, 61623, 2112, 6601, 11090, 15067, 20068, 24557, 28022, 31999, 38025, 34048, 47003, 42514, 53933, 49956, 61887, 57398, 6337, 2376, 15315, 10842, 24293, 20332, 32247, 27774, 42250, 46211, 34328, 38801, 58158, 62119, 49212, 53685, 10562, 14539, 2640, 7129, 28518, 32495, 19572, 24061, 46475, 41986, 38553, 34576, 62383, 57894, 53437, 49460, 14787, 10314, 6865, 2904, 32743, 28270, 23797, 19836, 50700, 55173, 58654, 62615, 32808, 37281, 41786, 45747, 19012, 23501, 26966, 30943, 3168, 7657, 12146, 16123, 54925, 50948, 62879, 58390, 37033, 33056, 46011, 41522, 23237, 19276, 31191, 26718, 7393, 3432, 16371, 11898, 59150, 63111, 50204, 54677, 41258, 45219, 33336, 37809, 27462, 31439, 18516, 23005, 11618, 15595, 3696, 8185, 63375, 58886, 54429, 50452, 45483, 40994, 37561, 33584, 31687, 27214, 22741, 18780, 15843, 11370, 7921, 3960};

        public ByteArrayView(byte[] bytes) {
            this(bytes, 0, bytes.length);
        }

        public ByteArrayView(byte[] bytes, int offset, int length) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        public boolean checkOffset(int offset, int length, int count) {
            int endOffset = offset + length * count;
            return endOffset <= this.length;
        }

        public ByteArrayView sliceEntry(int offset, int length) {
            return new ByteArrayView(this.bytes, this.offset + offset, length);
        }

        public ByteArrayView sliceTableEntry(int offset, int length, int index) {
            int tableEntryOffset = offset + index * length;
            return this.sliceEntry(tableEntryOffset, length);
        }

        public int readI8(int offset) {
            if (!this.checkOffset(offset, 1, 1)) {
                throw new IndexOutOfBoundsException();
            }
            byte result = this.bytes[this.offset + offset];
            return result;
        }

        public int readU8(int offset) {
            int result = this.readI8(offset) & 0xFF;
            return result;
        }

        public int readI16(int offset) {
            int result = 0;
            result += this.readU8(offset);
            return result += this.readI8(offset + 1) << 8;
        }

        public int readU16(int offset) {
            int result = 0;
            result += this.readU8(offset);
            return result += this.readU8(offset + 1) << 8;
        }

        public int readI32(int offset) {
            int result = 0;
            result += this.readU8(offset);
            result += this.readU8(offset + 1) << 8;
            result += this.readU8(offset + 2) << 16;
            return result += this.readI8(offset + 3) << 24;
        }

        public long readU32(int offset) {
            long result = 0L;
            result += (long)this.readU8(offset);
            result += (long)this.readU8(offset + 1) << 8;
            result += (long)this.readU8(offset + 2) << 16;
            return result += (long)this.readI8(offset + 3) << 24;
        }

        public long readI64(int offset) {
            long result = 0L;
            result += (long)this.readU8(offset);
            result += (long)this.readU8(offset + 1) << 8;
            result += (long)this.readU8(offset + 2) << 16;
            result += (long)this.readU8(offset + 3) << 24;
            result += (long)this.readU8(offset + 4) << 32;
            result += (long)this.readU8(offset + 5) << 40;
            result += (long)this.readU8(offset + 6) << 48;
            return result += (long)this.readI8(offset + 7) << 56;
        }

        public int calcCrc16(int start, int length) {
            int crc = 65535;
            for (int offset = 0; offset < length; ++offset) {
                int b = this.readU8(start + offset);
                crc = crc >> 8 ^ this.crc16Table[(crc ^ b) & 0xFF];
            }
            return crc ^ 0xFFFF;
        }
    }

    public class PacketTemplateFieldPart {
        int offset;
        int bitPos;
        int mask;
        boolean isSigned;
        long factor;

        public int getOffset() {
            return this.offset;
        }

        public int getBitPos() {
            return this.bitPos;
        }

        public int getMask() {
            return this.mask;
        }

        public boolean isSigned() {
            return this.isSigned;
        }

        public long getFactor() {
            return this.factor;
        }
    }

    public class PacketTemplateField {
        int idTextIndex;
        int nameLocalizedTextIndex;
        int unitId;
        int precision;
        int typeId;
        ArrayList<PacketTemplateFieldPart> parts = new ArrayList();
        int enumId;

        public String getIdText() {
            return SpecificationFile.this.getTextByIndex(this.idTextIndex);
        }

        public String getNameLocalizedText(Language language) {
            return SpecificationFile.this.getLocalizedTextByIndex(this.nameLocalizedTextIndex, language);
        }

        public Unit getUnit() {
            return SpecificationFile.this.getUnitById(this.unitId);
        }

        public int getPrecision() {
            return this.precision;
        }

        public Type getType() {
            return SpecificationFile.this.getTypeById(this.typeId);
        }

        public PacketTemplateFieldPart[] getParts() {
            return this.parts.toArray(new PacketTemplateFieldPart[this.parts.size()]);
        }

        public Enum getEnum() {
            return SpecificationFile.this.getEnumById(this.enumId);
        }
    }

    public static enum Type {
        Number,
        Time,
        WeekTime,
        DateTime;

    }

    public class PacketTemplate {
        int destinationAddress;
        int destinationMask;
        int sourceAddress;
        int sourceMask;
        int command;
        ArrayList<PacketTemplateField> fields = new ArrayList();

        public int getDestinationAddress() {
            return this.destinationAddress;
        }

        public int getDestinationMask() {
            return this.destinationMask;
        }

        public int getSourceAddress() {
            return this.sourceAddress;
        }

        public int getSourceMask() {
            return this.sourceMask;
        }

        public int getCommand() {
            return this.command;
        }

        public PacketTemplateField[] getFields() {
            return this.fields.toArray(new PacketTemplateField[this.fields.size()]);
        }
    }

    public class Enum {
        private int enumId;
        private long[] values;
        private EnumVariant[] enumVariants;

        protected Enum(int enumId, long[] values, EnumVariant[] enumVariants) {
            this.enumId = enumId;
            this.values = values;
            this.enumVariants = enumVariants;
        }

        public int getEnumId() {
            return this.enumId;
        }

        public long[] getValues() {
            return this.values;
        }

        public EnumVariant[] getEnumVariants() {
            return this.enumVariants;
        }

        public EnumVariant getEnumVariantForValue(long value) {
            int index = Arrays.binarySearch(this.values, value);
            EnumVariant enumVariant = index >= 0 ? this.enumVariants[index] : null;
            return enumVariant;
        }
    }

    public class EnumVariant {
        private int enumVariantId;
        private String enumVariantCode;
        private String textEn;
        private String textDe;
        private String textFr;

        public EnumVariant(int enumVariantId, String enumVariantCode, String textEn, String textDe, String textFr) {
            this.enumVariantId = enumVariantId;
            this.enumVariantCode = enumVariantCode;
            this.textEn = textEn;
            this.textDe = textDe;
            this.textFr = textFr;
        }

        public int getEnumVariantId() {
            return this.enumVariantId;
        }

        public String getEnumVariantCode() {
            return this.enumVariantCode;
        }

        public String getText(Language language) {
            String result;
            switch (language) {
                case En: {
                    result = this.textEn;
                    break;
                }
                case De: {
                    result = this.textDe;
                    break;
                }
                case Fr: {
                    result = this.textFr;
                    break;
                }
                default: {
                    result = this.textEn;
                }
            }
            return result;
        }

        public String getText() {
            return this.textEn;
        }
    }

    public class DeviceTemplate {
        int selfAddress;
        int selfMask;
        int peerAddress;
        int peerMask;
        int nameLocalizedTextIndex;

        public int getSelfAddress() {
            return this.selfAddress;
        }

        public int getSelfMask() {
            return this.selfMask;
        }

        public int getPeerAddress() {
            return this.peerAddress;
        }

        public int getPeerMask() {
            return this.peerMask;
        }

        public String getNameLocalizedText(Language language) {
            return SpecificationFile.this.getLocalizedTextByIndex(this.nameLocalizedTextIndex, language);
        }
    }

    public class Unit {
        int unitId;
        int unitFamilyId;
        int unitCodeTextIndex;
        int unitTextTextIndex;

        public int getUnitId() {
            return this.unitId;
        }

        public UnitFamily getUnitFamily() {
            return SpecificationFile.this.getUnitFamilyById(this.unitFamilyId);
        }

        public String getUnitCodeText() {
            return SpecificationFile.this.getTextByIndex(this.unitCodeTextIndex);
        }

        public String getUnitTextText() {
            return SpecificationFile.this.getTextByIndex(this.unitTextTextIndex);
        }
    }

    public static enum UnitFamily {
        None,
        Temperature,
        Energy,
        VolumeFlow,
        Pressure,
        Volume,
        Time,
        Power;

    }

    public class LocalizedText {
        int textIndexEn;
        int textIndexDe;
        int textIndexFr;
    }

    public static enum Language {
        En,
        De,
        Fr;

    }

    public static enum Error {
        InvalidFileHeader,
        InvalidFileHeaderTotalLength,
        InvalidFileHeaderChecksumA,
        InvalidFileHeaderChecksumB,
        InvalidFileHeaderDataVersion,
        InvalidFileHeaderSpecificationOffset,
        InvalidSpecificationTextTable,
        InvalidSpecificationLocalizedTextTable,
        InvalidSpecificationUnitTable,
        InvalidSpecificationDeviceTemplateTable,
        InvalidSpecificationPacketTemplateTable,
        InvalidTextStringOffset,
        InvalidTextContent,
        InvalidLocalizedTextTextIndexEn,
        InvalidLocalizedTextTextIndexDe,
        InvalidLocalizedTextTextIndexFr,
        InvalidUnitUnitFamilyId,
        InvalidUnitUnitCodeTextIndex,
        InvalidUnitUnitTextTextIndex,
        InvalidDeviceTemplateNameLocalizedTextIndex,
        InvalidPacketTemplateFieldTable,
        InvalidPacketTemplateFieldIdTextIndex,
        InvalidPacketTemplateFieldNameLocalizedTextIndex,
        InvalidPacketTemplateFieldUnitId,
        InvalidPacketTemplateFieldTypeId,
        InvalidPacketTemplateFieldPartTable;

    }
}

