/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.ConfigurationOptimizer;
import de.resol.vbus.ConfigurationValue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TimeZone;

public abstract class BaseConfigurationOptimizer
implements ConfigurationOptimizer {
    @Override
    public ConfigurationValue[] completeConfiguration(ConfigurationValue[] values) {
        boolean forcePending;
        ConfigurationValue[] templateValues;
        ConfigurationValue[] adjustableValues = this.getAdjustableValues();
        if (values != null) {
            templateValues = values;
            forcePending = false;
        } else {
            templateValues = adjustableValues;
            forcePending = true;
        }
        HashMap<Integer, ConfigurationValue> valueByIndex = null;
        HashMap<Integer, ConfigurationValue> valueByIdHash = null;
        ConfigurationValue[] completedValues = new ConfigurationValue[templateValues.length];
        for (int i = 0; i < templateValues.length; ++i) {
            ConfigurationValue completedValue;
            ConfigurationValue value = templateValues[i];
            if (value.getValueIndex() != 0) {
                if (valueByIndex == null) {
                    valueByIndex = new HashMap<Integer, ConfigurationValue>();
                    for (ConfigurationValue adjValue : adjustableValues) {
                        valueByIndex.put(adjValue.getValueIndex(), adjValue);
                    }
                }
                completedValue = (ConfigurationValue)valueByIndex.get(value.getValueIndex());
            } else if (value.getValueIdHash() != 0 || value.getValueId() != null) {
                int valueIdHash;
                if (valueByIdHash == null) {
                    valueByIdHash = new HashMap<Integer, ConfigurationValue>();
                    for (ConfigurationValue adjValue : adjustableValues) {
                        valueByIdHash.put(adjValue.getValueIdHash(), adjValue);
                    }
                }
                if ((valueIdHash = value.getValueIdHash()) == 0) {
                    valueIdHash = ConfigurationValue.hashValueId(value.getValueId());
                }
                completedValue = (ConfigurationValue)valueByIdHash.get(valueIdHash);
            } else {
                completedValue = null;
            }
            if (completedValue == null) {
                completedValue = value;
            }
            completedValue = completedValue.clone();
            completedValue.setValue(value.getValue());
            completedValue.setPending(forcePending ? true : value.isPending());
            completedValue.setTransceived(forcePending ? false : value.isTransceived());
            completedValues[i] = completedValue;
        }
        Arrays.sort(completedValues, new Comparator<ConfigurationValue>(){

            @Override
            public int compare(ConfigurationValue l, ConfigurationValue r) {
                int diff = r.getPriority() - l.getPriority();
                if (diff == 0) {
                    diff = l.getValueIndex() - r.getValueIndex();
                }
                return diff;
            }
        });
        return completedValues;
    }

    @Override
    public ConfigurationValue[] optimizeLoadConfiguration(ConfigurationValue[] values) {
        return values;
    }

    @Override
    public ConfigurationValue[] optimizeSaveConfiguration(ConfigurationValue[] newValues, ConfigurationValue[] oldValues) {
        return newValues;
    }

    @Override
    public ConfigurationValue[] generateClockConfiguration(long time, TimeZone timeZone) {
        return new ConfigurationValue[0];
    }

    public abstract ConfigurationValue[] getAdjustableValues();
}

