/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.Connection;
import de.resol.vbus.ConnectionListener;
import de.resol.vbus.Datagram;
import de.resol.vbus.Header;
import de.resol.vbus.Packet;
import de.resol.vbus.Telegram;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;

public abstract class BaseDeviceEmulator
implements ConnectionListener {
    private Connection connection;
    private Connection.ConnectionState connectionState;
    private final PropertyChangeSupport pcs;

    public BaseDeviceEmulator(Connection connection) {
        this.connection = connection;
        this.connectionState = Connection.ConnectionState.DISCONNECTED;
        this.pcs = new PropertyChangeSupport(this);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Connection.ConnectionState getConnectionState() {
        return this.connectionState;
    }

    private void setConnectionState(Connection.ConnectionState newValue) {
        Connection.ConnectionState oldValue = this.connectionState;
        if (oldValue != newValue) {
            this.connectionState = newValue;
            this.pcs.firePropertyChange("connectionState", (Object)oldValue, (Object)newValue);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propName, listener);
    }

    protected void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propName, oldValue, newValue);
    }

    public void start() {
        this.connection.addListener(this);
        this.setConnectionState(this.connection.getConnectionState());
    }

    public void stop() {
        this.connection.removeListener(this);
        this.setConnectionState(Connection.ConnectionState.DISCONNECTED);
    }

    @Override
    public void connectionStateChanged(Connection connection) {
        this.setConnectionState(connection.getConnectionState());
    }

    @Override
    public void packetReceived(Connection connection, Packet packet) {
    }

    @Override
    public void datagramReceived(Connection connection, Datagram dgram) {
    }

    @Override
    public void telegramReceived(Connection connection, Telegram tgram) {
    }

    public abstract int update(int var1);

    public void send(Header header) {
        try {
            this.getConnection().send(header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

