/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.Header;
import de.resol.vbus.HeaderSetListener;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;

public class HeaderSet<T extends Header> {
    protected long timestamp;
    protected ArrayList<T> headerList;
    protected ArrayList<HeaderSetListener<T>> listeners;

    public HeaderSet(long timestamp) {
        this.timestamp = timestamp;
        this.headerList = new ArrayList();
        this.listeners = new ArrayList();
    }

    public HeaderSet(long timestamp, T ... headers) {
        this(timestamp);
        for (T header : headers) {
            this.addHeader(header);
        }
        this.timestamp = timestamp;
    }

    public HeaderSet(long timestamp, Iterator<T> headers) {
        this(timestamp);
        while (headers.hasNext()) {
            this.addHeader((Header)headers.next());
        }
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void addListener(HeaderSetListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(HeaderSetListener<T> listener) {
        this.listeners.remove(listener);
    }

    private int findIndex(T header) {
        int result = -1;
        for (int i = 0; i < this.headerList.size(); ++i) {
            if (((Header)this.headerList.get(i)).compareTo((Header)header) != 0) continue;
            result = i;
            break;
        }
        return result;
    }

    public boolean containsHeader(T header) {
        return this.findIndex(header) >= 0;
    }

    public void addHeader(T header) {
        int index = this.findIndex(header);
        if (index >= 0) {
            this.headerList.set(index, header);
        } else {
            this.headerList.add(header);
        }
        if (this.timestamp < ((Header)header).timestamp) {
            this.timestamp = ((Header)header).timestamp;
        }
        for (HeaderSetListener<T> listener : this.listeners) {
            listener.headerAdded(this, header);
        }
    }

    public void addHeaders(T ... headers) {
        for (T header : headers) {
            this.addHeader(header);
        }
    }

    private void removeHeader(int index) {
        this.headerList.remove(index);
    }

    public void removeAllHeaders() {
        while (this.headerList.size() > 0) {
            this.removeHeader(this.headerList.size() - 1);
        }
    }

    public void removeHeadersOlderThan(long timestamp) {
        for (int index = this.headerList.size() - 1; index >= 0; --index) {
            if (((Header)this.headerList.get((int)index)).timestamp >= timestamp) continue;
            this.removeHeader(index);
        }
    }

    public int getHeaderCount() {
        return this.headerList.size();
    }

    public Iterator<T> getHeaderIterator() {
        return this.headerList.iterator();
    }

    public T[] getHeaders(T[] array) {
        return (Header[])this.headerList.toArray(array);
    }

    private ArrayList<T> getSortedHeaderList() {
        ArrayList<T> sortedHeaderList = new ArrayList<T>(this.headerList);
        sortedHeaderList.sort(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Header)o1).compareTo((Header)o2);
            }
        });
        return sortedHeaderList;
    }

    public ListIterator<T> getSortedHeaderListIterator() {
        return this.getSortedHeaderList().listIterator();
    }

    public T[] getSortedHeaders(T[] array) {
        return (Header[])this.getSortedHeaderList().toArray(array);
    }

    public HeaderSet<T> getSortedHeaderSet() {
        ArrayList<T> sortedHeaderList = this.getSortedHeaderList();
        return new HeaderSet<T>(this.timestamp, sortedHeaderList.listIterator());
    }

    public String getId() {
        ArrayList<T> sortedHeaderList = this.getSortedHeaderList();
        StringBuilder sb = new StringBuilder();
        for (Header header : sortedHeaderList) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(header.getId());
        }
        return sb.toString();
    }

    public String getIdHash() {
        try {
            String id = this.getId();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(id.getBytes("UTF-8"));
            byte[] digest = md.digest();
            String idHash = String.format("%064x", new BigInteger(1, digest));
            return idHash;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

