/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus;

import de.resol.vbus.Header;

public class Telegram
extends Header {
    protected int command;
    protected byte[] frameData;

    public Telegram(long timestamp, int channel, int destinationAddress, int sourceAddress, int command, byte[] frameData) {
        super(timestamp, channel, destinationAddress, sourceAddress);
        this.command = command;
        this.frameData = frameData;
    }

    public int getCommand() {
        return this.command;
    }

    public byte[] getFrameData() {
        return this.frameData;
    }

    @Override
    public int getProtocolVersion() {
        return 48;
    }

    @Override
    public byte[] toLiveBuffer(byte[] _buffer, int _start, int _length) {
        int start;
        byte[] buffer;
        int liveLength = 8 + this.getFrameCount() * 9;
        if (_buffer == null) {
            buffer = new byte[liveLength];
            start = 0;
        } else if (_length >= liveLength) {
            buffer = _buffer;
            start = _start;
        } else {
            buffer = null;
            start = 0;
        }
        if (buffer != null) {
            buffer[start + 0] = -86;
            buffer[start + 1] = (byte)(this.destinationAddress & 0x7F);
            buffer[start + 2] = (byte)(this.destinationAddress >> 8 & 0x7F);
            buffer[start + 3] = (byte)(this.sourceAddress & 0x7F);
            buffer[start + 4] = (byte)(this.sourceAddress >> 8 & 0x7F);
            buffer[start + 5] = 48;
            buffer[start + 6] = (byte)(this.command & 0x7F);
            Telegram.calcAndSetChecksumV0(buffer, start + 1, 6);
            int frameCount = this.getFrameCount();
            for (int frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
                int srcStart = frameIndex * 7;
                int dstStart = start + 8 + frameIndex * 9;
                Telegram.extractSeptett(this.frameData, srcStart, 7, buffer, dstStart);
                Telegram.calcAndSetChecksumV0(buffer, dstStart, 8);
            }
        }
        return buffer;
    }

    @Override
    public String getId() {
        return String.format("%s_%02X", super.getId(), this.command);
    }

    @Override
    public int compareTo(Header _that) {
        int result = super.compareTo(_that);
        if (result == 0) {
            Telegram that = (Telegram)_that;
            result = this.command - that.command;
        }
        return result;
    }

    public int getFrameCount() {
        return Telegram.getFrameCountForCommand(this.command);
    }

    public static int getFrameCountForCommand(int command) {
        return command >> 5 & 3;
    }

    public static Telegram fromLiveBuffer(byte[] buffer, int start, int length, long timestamp, int channel) {
        Telegram tgram;
        boolean valid;
        if ((buffer[start] & 0xFF) != 170) {
            valid = false;
        } else if (length < 8) {
            valid = false;
        } else if (!Telegram.checkMsbs(buffer, start + 1, 7)) {
            valid = false;
        } else if (!Telegram.calcAndCompareChecksumV0(buffer, start + 1, 6)) {
            valid = false;
        } else if (buffer[start + 5] != 48) {
            valid = false;
        } else {
            int frameCount = Telegram.getFrameCountForCommand(buffer[start + 6]);
            int minLength = 8 + frameCount * 9;
            if (length < minLength) {
                valid = false;
            } else if (!Telegram.checkMsbs(buffer, start + 8, minLength - 8)) {
                valid = false;
            } else {
                valid = true;
                for (int frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
                    if (Telegram.calcAndCompareChecksumV0(buffer, start + 8 + frameIndex * 9, 8)) continue;
                    valid = false;
                    break;
                }
            }
        }
        if (valid) {
            int destinationAddress = buffer[start + 1] & 0x7F | (buffer[start + 2] & 0x7F) << 8;
            int sourceAddress = buffer[start + 3] & 0x7F | (buffer[start + 4] & 0x7F) << 8;
            int command = buffer[start + 6] & 0x7F;
            int frameCount = Telegram.getFrameCountForCommand(command);
            byte[] frameData = new byte[frameCount * 7];
            for (int frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
                int srcStart = start + 8 + frameIndex * 9;
                int dstStart = frameIndex * 7;
                Telegram.injectSeptett(buffer, srcStart, 7, frameData, dstStart);
            }
            tgram = new Telegram(timestamp, channel, destinationAddress, sourceAddress, command, frameData);
        } else {
            tgram = null;
        }
        return tgram;
    }
}

