/*
 * Decompiled with CFR 0.152.
 */
package de.resol.vbus.deviceemulators;

import de.resol.vbus.BaseDeviceEmulator;
import de.resol.vbus.Connection;
import de.resol.vbus.LittleEndianBuffer;
import de.resol.vbus.Packet;

public class EmDeviceEmulator
extends BaseDeviceEmulator {
    private static final int BASE_ADDRESS = 26192;
    private int subAddress;
    private int[] resistorValues;
    private Relay[] relais;
    private int timeout;

    public EmDeviceEmulator(Connection connection, int subAddress) {
        super(connection);
        if (subAddress < 1 || subAddress > 15) {
            throw new Error("Sub address must be between 1 and 15");
        }
        this.subAddress = subAddress;
        this.resistorValues = new int[]{1000000000, 1000000000, 1000000000, 1000000000, 1000000000, 1000000000};
        this.relais = new Relay[]{new Relay(), new Relay(), new Relay(), new Relay(), new Relay()};
    }

    public int getSubAddress() {
        return this.subAddress;
    }

    private void checkResistorNr(int nr) {
        if (nr < 1 || nr > 6) {
            throw new IndexOutOfBoundsException("Resistor number must be between 1 and 6");
        }
    }

    public int getResistorValueByNr(int nr) {
        this.checkResistorNr(nr);
        return this.resistorValues[nr - 1];
    }

    public void setResistorValueByNr(int nr, int newValue) {
        this.checkResistorNr(nr);
        int oldValue = this.resistorValues[nr - 1];
        if (oldValue != newValue) {
            this.resistorValues[nr - 1] = newValue;
            this.firePropertyChange("resistorValue" + nr, oldValue, newValue);
        }
    }

    public void setResistorValueByNrAndPt1000Temperatur(int nr, float temperature) {
        float t1 = temperature;
        float t2 = t1 * t1;
        float t3 = t2 * t1;
        float a = 0.0039083f;
        float b = -5.775E-7f;
        float c = t1 < 0.0f ? -4.183E-12f : 0.0f;
        float resistor = 1000.0f * (1.0f + a * t1 + b * t2 + c * (t1 - 100.0f) * t3);
        this.setResistorValueByNr(nr, Math.round(resistor * 1000.0f));
    }

    public void setResistorValueByNrAndBasSettings(int nr, float temperature, int mode) {
        float modeResistor;
        float temperatureResistor = temperature <= -15.0f ? 20.0f : (temperature >= 15.0f ? 480.0f : 250.0f + temperature / 15.0f * 210.0f);
        switch (mode) {
            case 1: {
                modeResistor = 36.0f;
                break;
            }
            case 2: {
                modeResistor = 620.0f;
                break;
            }
            case 3: {
                modeResistor = 1200.0f;
                break;
            }
            case 4: {
                modeResistor = 1800.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported BAS mode " + mode);
            }
        }
        float resistor = temperatureResistor + modeResistor;
        this.setResistorValueByNr(nr, Math.round(resistor * 1000.0f));
    }

    private void checkRelayNr(int nr) {
        if (nr < 1 || nr > 5) {
            throw new IndexOutOfBoundsException("Relay number must be between 1 and 5");
        }
    }

    private Relay getRelayRefByNr(int nr) {
        this.checkRelayNr(nr);
        return this.relais[nr - 1];
    }

    public Relay getRelayByNr(int nr) {
        Relay relayRef = this.getRelayRefByNr(nr);
        return relayRef;
    }

    public int getRelayValueByNr(int nr) {
        Relay relayRef = this.getRelayRefByNr(nr);
        return relayRef.value;
    }

    @Override
    public void packetReceived(Connection connection, Packet rxPacket) {
        super.packetReceived(connection, rxPacket);
        if (rxPacket.getDestinationAddress() == 26192 + this.subAddress && rxPacket.getCommand() == 512 && rxPacket.getFrameCount() >= 10) {
            LittleEndianBuffer rxFrameData = new LittleEndianBuffer(rxPacket.getFrameData(), 0, 40);
            for (int relayIndex = 0; relayIndex < 5; ++relayIndex) {
                int start = relayIndex * 8;
                Relay relay = this.relais[relayIndex];
                relay.value1 = rxFrameData.readU8(start);
                relay.time1 = rxFrameData.readU24(start + 1) * 1000;
                relay.value2 = rxFrameData.readU8(start + 4);
                relay.time2 = rxFrameData.readU24(start + 5) * 1000;
            }
            this.timeout = 30000;
            this.update(0);
            LittleEndianBuffer txFrameData = new LittleEndianBuffer(24);
            for (int sensorIndex = 0; sensorIndex < 6; ++sensorIndex) {
                int start = sensorIndex * 4;
                txFrameData.writeI32(start, this.resistorValues[sensorIndex]);
            }
            Packet txPacket = new Packet(System.currentTimeMillis(), rxPacket.getChannel(), rxPacket.getSourceAddress(), rxPacket.getDestinationAddress(), 256, 6, txFrameData.getBuffer());
            this.send(txPacket);
        }
    }

    @Override
    public int update(int deltaMs) {
        this.timeout = this.timeout > deltaMs ? (this.timeout -= deltaMs) : 0;
        if (this.timeout == 0) {
            for (Relay relay : this.relais) {
                relay.reset();
            }
        }
        for (int relayNr = 1; relayNr <= 5; ++relayNr) {
            Relay relay = this.getRelayRefByNr(relayNr);
            int oldValue = relay.value;
            relay.update(deltaMs);
            if (relay.value == oldValue) continue;
            this.firePropertyChange("relay" + relayNr + "Value", oldValue, relay.value);
        }
        int sleepTime = Math.min(this.timeout, 1000);
        return sleepTime;
    }

    public static class Relay {
        private int value1;
        private int time1;
        private int value2;
        private int time2;
        private int timer;
        private int value;

        public int getValue1() {
            return this.value1;
        }

        public int getTime1() {
            return this.time1;
        }

        public int getValue2() {
            return this.value2;
        }

        public int getTime2() {
            return this.time2;
        }

        public int getValue() {
            return this.value;
        }

        private void update(int deltaMs) {
            this.timer += deltaMs;
            int totalTime = this.time1 + this.time2;
            this.timer = totalTime > 0 ? (this.timer %= totalTime) : 0;
            this.value = totalTime == 0 ? 0 : (this.timer < this.time1 ? this.value1 : this.value2);
        }

        private void reset() {
            this.value1 = 0;
            this.time1 = 0;
            this.value2 = 0;
            this.time2 = 0;
            this.update(0);
        }
    }
}

