/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.logs;

import de.retest.recheck.logs.LogLineParser;
import de.retest.recheck.ui.Path;
import de.retest.recheck.ui.PathElement;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.MutableAttributes;
import de.retest.recheck.ui.descriptors.PathAttribute;
import de.retest.recheck.ui.descriptors.RetestIdProviderUtil;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.StringAttribute;
import de.retest.recheck.ui.descriptors.SuffixAttribute;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class LogFileParser {
    public static final String CONFIGURED_PATTERN_CONFIG_KEY = "de.retest.recheck.logs.pattern";
    public static final String LOGBACK_DEFAULT_PATTERN = "(?<dateTime>[-:\\d ]+) (?<level>[\\w]+) \\[(?<thread>.+)\\] (?<logger>[\\w\\.]+) - (?<message>.*)";
    public static final String LOG4J_DEFAULT_PATTERN = "(?<message>.*)";
    public static final String LOG4J_TTCC_CONVERSION_PATTERN = "(?<millis>[\\d]+) \\[(?<thread>.+)\\] (?<level>[\\w]+) (?<category>.+) (?<nestedDiagnosticContext>.+) - (?<message>.*)";
    private static final String LOG_FILE_TYPE = "log-file";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RootElement parseLogFile(File logFile) {
        LogLineParser lineParser = new LogLineParser(System.getProperty(CONFIGURED_PATTERN_CONFIG_KEY, LOGBACK_DEFAULT_PATTERN));
        Path rootPath = Path.fromString((String)LOG_FILE_TYPE);
        RootElement root = this.createRoot(rootPath, logFile);
        StringBuffer current = new StringBuffer();
        try (BufferedReader br = new BufferedReader(new FileReader(logFile));){
            Path path;
            String line;
            int lineCounter = 0;
            while ((line = br.readLine()) != null) {
                path = Path.path((Path)rootPath, (PathElement)new PathElement("line", lineCounter));
                if (lineParser.isNewLine(line = line.trim())) {
                    String previous = current.toString();
                    if (!previous.isEmpty()) {
                        root.addChildren(new Element[]{lineParser.parseLine(root, path, previous, lineCounter)});
                    }
                    current = new StringBuffer(line);
                } else {
                    current.append("\n\t").append(line);
                }
                ++lineCounter;
            }
            String previous = current.toString().trim();
            if (!previous.isEmpty()) {
                path = Path.path((Path)rootPath, (PathElement)new PathElement("line", lineCounter));
                root.addChildren(new Element[]{lineParser.parseLine(root, path, previous, lineCounter)});
            }
            RootElement rootElement = root;
            return rootElement;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read log file '" + logFile.getPath() + "'.", e);
        }
    }

    private RootElement createRoot(Path path, File logFile) {
        ArrayList<Object> attributes = new ArrayList<Object>();
        attributes.add(new PathAttribute(path));
        attributes.add(new SuffixAttribute(0));
        attributes.add(new StringAttribute("type", LOG_FILE_TYPE));
        attributes.add(new StringAttribute("fileName", logFile.getName()));
        IdentifyingAttributes identifyingAttributes = new IdentifyingAttributes(attributes);
        return new RootElement(RetestIdProviderUtil.getRetestId((IdentifyingAttributes)identifyingAttributes), identifyingAttributes, new MutableAttributes().immutable(), null, "", 0, logFile.getName());
    }
}

