/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.logs;

import de.retest.recheck.ui.Path;
import de.retest.recheck.ui.PathElement;
import de.retest.recheck.ui.descriptors.Attributes;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import de.retest.recheck.ui.descriptors.MutableAttributes;
import de.retest.recheck.ui.descriptors.PathAttribute;
import de.retest.recheck.ui.descriptors.RetestIdProviderUtil;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.StringAttribute;
import de.retest.recheck.ui.descriptors.SuffixAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogLineParser {
    public static final String LINE_TYPE = "line";
    private final Pattern pattern;
    private final List<String> groupNames;

    public LogLineParser(String pattern) {
        this.pattern = Pattern.compile(pattern);
        this.groupNames = this.parseGroupNames(pattern);
    }

    private List<String> parseGroupNames(String pattern) {
        Pattern groupNamePattern = Pattern.compile("\\?\\<([\\w]*)\\>");
        Matcher matcher = groupNamePattern.matcher(pattern);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    public boolean isNewLine(String line) {
        Matcher matcher = this.pattern.matcher(line);
        return matcher.find();
    }

    public Element parseLine(RootElement root, Path path, String line, int lineCounter) {
        if (line == null || line.isEmpty()) {
            throw new IllegalArgumentException("Line cannot be null or empty!");
        }
        Matcher matcher = this.pattern.matcher(line);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Parsing log file should work such that all lines that belong together are delivered together, i.e. stack trace.");
        }
        Element lineElement = this.createLineElement(root, path, lineCounter);
        for (String groupName : this.groupNames) {
            try {
                String group = matcher.group(groupName).trim();
                if (group.isEmpty()) continue;
                lineElement.addChildren(new Element[]{this.createChild(lineElement, path, lineCounter, group, groupName)});
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return lineElement;
    }

    private Element createChild(Element parent, Path path, int lineCounter, String group, String groupName) {
        ArrayList<Object> identAttributes = new ArrayList<Object>();
        identAttributes.add(new PathAttribute(Path.path((Path)path, (PathElement)new PathElement(groupName, lineCounter))));
        identAttributes.add(new SuffixAttribute(lineCounter));
        identAttributes.add(new StringAttribute("type", groupName));
        MutableAttributes attributes = new MutableAttributes();
        attributes.put("text", group);
        IdentifyingAttributes identifyingAttributes = new IdentifyingAttributes(identAttributes);
        return Element.create((String)RetestIdProviderUtil.getRetestId((IdentifyingAttributes)identifyingAttributes), (Element)parent, (IdentifyingAttributes)identifyingAttributes, (Attributes)attributes.immutable());
    }

    private Element createLineElement(RootElement root, Path path, int lineCounter) {
        ArrayList<Object> attributes = new ArrayList<Object>();
        attributes.add(new PathAttribute(path));
        attributes.add(new SuffixAttribute(lineCounter));
        attributes.add(new StringAttribute("type", LINE_TYPE));
        IdentifyingAttributes identifyingAttributes = new IdentifyingAttributes(attributes);
        return Element.create((String)RetestIdProviderUtil.getRetestId((IdentifyingAttributes)identifyingAttributes), (Element)root, (IdentifyingAttributes)identifyingAttributes, (Attributes)new MutableAttributes().immutable());
    }
}

