/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.testng;

import de.retest.recheck.RecheckLifecycle;
import de.retest.recheck.util.ReflectionUtilities;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class Execute {
    private final Consumer<RecheckLifecycle> consumer;

    private Execute(Consumer<RecheckLifecycle> consumer) {
        this.consumer = consumer;
    }

    public static Execute execute(Consumer<RecheckLifecycle> consumer) {
        return new Execute(consumer);
    }

    public void on(Object object) {
        this.findRecheckLifecycleFields(object).forEach(field -> this.execute((Field)field, object));
    }

    private void execute(Field field, Object testInstance) {
        this.unlock(field);
        this.doExecute(field, testInstance);
        this.lock(field);
    }

    private void doExecute(Field field, Object testInstance) {
        try {
            this.consumer.accept((RecheckLifecycle)field.get(testInstance));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    private Stream<Field> findRecheckLifecycleFields(Object testInstance) {
        return ReflectionUtilities.getAllFields(testInstance.getClass()).stream().filter(this::isRecheckLifecycle);
    }

    private boolean isRecheckLifecycle(Field field) {
        return RecheckLifecycle.class.isAssignableFrom(field.getType());
    }

    private void unlock(Field field) {
        field.setAccessible(true);
    }

    private void lock(Field field) {
        field.setAccessible(false);
    }
}

