/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.testng;

import de.retest.recheck.RecheckLifecycle;
import de.retest.recheck.testng.Execute;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestResult;

public class RecheckHook
implements IHookable {
    public void run(IHookCallBack callBack, ITestResult testResult) {
        this.startTest(testResult);
        callBack.runTestMethod(testResult);
        try {
            this.capTest(testResult);
        }
        finally {
            this.cap(testResult);
        }
    }

    private void startTest(ITestResult result) {
        String testName = this.resolveName(result);
        Object testInstance = result.getInstance();
        Consumer<RecheckLifecycle> startTest = lifecycle -> lifecycle.startTest(testName);
        Execute.execute(startTest).on(testInstance);
    }

    private String resolveName(ITestResult result) {
        String parameters = this.concatParameters(result);
        return result.getName() + parameters;
    }

    private String concatParameters(ITestResult result) {
        Object[] parameters = result.getParameters();
        if (parameters == null || parameters.length == 0) {
            return "";
        }
        return Arrays.stream(parameters).map(Objects::toString).collect(Collectors.joining("_", "_", ""));
    }

    private void capTest(ITestResult result) {
        Object testInstance = result.getInstance();
        Consumer<RecheckLifecycle> cap = RecheckLifecycle::capTest;
        Execute.execute(cap).on(testInstance);
    }

    private void cap(ITestResult result) {
        Object testInstance = result.getInstance();
        Consumer<RecheckLifecycle> cap = RecheckLifecycle::cap;
        Execute.execute(cap).on(testInstance);
    }
}

