/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.retest.web.AttributesConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributesProvider {
    public static final String ATTRIBUTES_FILE_PROPERTY = "de.retest.recheck.web.attributesFile";
    public static final String DEFAULT_ATTRIBUTES_FILE_PATH = "/attributes.yaml";
    private static final Logger logger = LoggerFactory.getLogger(AttributesProvider.class);
    private static AttributesProvider instance;
    private final AttributesConfig attributesConfig = this.readAttributesConfig();

    private AttributesProvider() {
    }

    public static AttributesProvider getInstance() {
        if (instance == null) {
            instance = new AttributesProvider();
        }
        return instance;
    }

    static AttributesProvider getTestInstance() {
        logger.warn("A test instance of {} is being used.", (Object)AttributesProvider.class.getSimpleName());
        return new AttributesProvider();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AttributesConfig readAttributesConfig() {
        String userAttributesFilePath = System.getProperty(ATTRIBUTES_FILE_PROPERTY);
        if (userAttributesFilePath != null) {
            Path userAttributes = Paths.get(userAttributesFilePath, new String[0]);
            logger.debug("Loading user-defined attributes file '{}'.", (Object)userAttributes);
            try (InputStream in = Files.newInputStream(userAttributes, new OpenOption[0]);){
                AttributesConfig attributesConfig = this.readAttributesConfigFromFile(in);
                return attributesConfig;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Cannot read attributes file '" + userAttributesFilePath + "'.", e);
            }
        }
        logger.debug("Loading default attributes file '{}'", (Object)DEFAULT_ATTRIBUTES_FILE_PATH);
        try (InputStream url = this.getClass().getResourceAsStream(DEFAULT_ATTRIBUTES_FILE_PATH);){
            AttributesConfig attributesConfig = this.readAttributesConfigFromFile(url);
            return attributesConfig;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read attributes file '/attributes.yaml'.", e);
        }
    }

    private AttributesConfig readAttributesConfigFromFile(InputStream in) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (AttributesConfig)mapper.readValue(in, AttributesConfig.class);
    }

    public List<String> getCssAttributes() {
        return this.attributesConfig.getCssAttributes();
    }

    public List<String> getHtmlAttributes() {
        return this.attributesConfig.getHtmlAttributes();
    }

    public List<String> getJoinedAttributes() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getHtmlAttributes());
        result.addAll(this.getCssAttributes());
        return result;
    }
}

