/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.IdentifyingAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultWebValueFinder
implements DefaultValueFinder {
    public static final String DEFAULTS_FILE_PATH = "/defaults.yaml";
    private static final Set<String> commonDefaults = new HashSet<String>(Arrays.asList("0px", "0px 0px", "auto", "normal", "rgb(0, 0, 0)", "none"));
    private final Map<String, Map<String, String>> defaultValues;

    public DefaultWebValueFinder() {
        try (InputStream url = this.getClass().getResourceAsStream(DEFAULTS_FILE_PATH);){
            this.defaultValues = this.readAttributesConfigFromFile(url);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read defaults file '/defaults.yaml'.", e);
        }
    }

    private Map<String, Map<String, String>> readAttributesConfigFromFile(InputStream in) throws IOException {
        HashMap<String, Map<String, String>> defaultValues = new HashMap<String, Map<String, String>>();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode jsonNode = mapper.readTree(in);
        Iterator elements = jsonNode.fields();
        while (elements.hasNext()) {
            Map.Entry field = (Map.Entry)elements.next();
            HashMap defaults = new HashMap();
            ArrayNode valuesNode = (ArrayNode)field.getValue();
            Iterator values = valuesNode.elements();
            while (values.hasNext()) {
                Map.Entry value = (Map.Entry)((JsonNode)values.next()).fields().next();
                defaults.put(value.getKey(), ((JsonNode)value.getValue()).asText());
            }
            defaultValues.put((String)field.getKey(), defaults);
        }
        return defaultValues;
    }

    public boolean isDefaultValue(IdentifyingAttributes identifyingAttributes, String attributeKey, Serializable attributeValue) {
        String attributeValueString = attributeValue != null ? attributeValue.toString() : null;
        String defaultValueString = this.getDefaultValue(identifyingAttributes, attributeKey);
        if (defaultValueString != null) {
            return defaultValueString.equalsIgnoreCase(attributeValueString);
        }
        if (attributeValueString == null || attributeValueString.trim().isEmpty()) {
            return true;
        }
        return commonDefaults.contains(attributeValueString);
    }

    String getDefaultValue(IdentifyingAttributes identifyingAttributes, String attribute) {
        String defaultValue;
        String tag = identifyingAttributes.getType();
        Map<String, String> defaults = this.defaultValues.get(tag.toLowerCase());
        if (defaults != null && (defaultValue = defaults.get(attribute.toLowerCase())) != null) {
            return defaultValue;
        }
        return this.defaultValues.get("all").get(attribute.toLowerCase());
    }
}

