/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.web.RootElementPeer;
import de.retest.web.WebData;
import de.retest.web.WebDataFilter;
import de.retest.web.WebElementPeer;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

class PeerConverter {
    private final RetestIdProvider idProvider;
    private final Map<String, Map<String, Object>> data;
    private final BufferedImage screenshot;
    private final String title;
    private final Map<String, WebElementPeer> converted = new HashMap<String, WebElementPeer>();
    private RootElementPeer root = null;
    private final DefaultValueFinder defaultValueFinder;

    public PeerConverter(RetestIdProvider idProvider, Map<String, Map<String, Object>> data, String title, BufferedImage screenshot, DefaultValueFinder defaultValueFinder) {
        this.idProvider = idProvider;
        this.data = data;
        this.title = title;
        this.screenshot = screenshot;
        this.defaultValueFinder = defaultValueFinder;
    }

    public RootElement convertToPeers() {
        this.idProvider.reset();
        for (Map.Entry<String, Map<String, Object>> entry : this.data.entrySet()) {
            String path = entry.getKey();
            WebData webData = new WebData(entry.getValue());
            if (WebDataFilter.shouldIgnore(webData)) continue;
            this.convertToPeer(path, webData);
        }
        if (this.root == null) {
            throw new NullPointerException("RootElementPeer is null.");
        }
        return this.root.toElement(null);
    }

    private WebElementPeer convertToPeer(String path, WebData webData) {
        String parentPath = PeerConverter.getParentPath(path);
        WebElementPeer peer = this.converted.get(path);
        if (peer != null) {
            return peer;
        }
        if (parentPath == null) {
            assert (this.root == null) : "We can only have one root element!";
            this.root = new RootElementPeer(webData, path, this.title, this.screenshot, this.defaultValueFinder);
            peer = this.root;
        } else {
            peer = new WebElementPeer(webData, path, this.defaultValueFinder);
            WebElementPeer parent = this.converted.get(parentPath);
            if (parent == null) {
                parent = this.convertToPeer(parentPath, new WebData(this.data.get(parentPath)));
            }
            parent.addChild(peer);
        }
        this.converted.put(path, peer);
        return peer;
    }

    static String getParentPath(String path) {
        String parentPath = path.substring(0, path.lastIndexOf(47));
        if (parentPath.length() == 1) {
            return null;
        }
        return parentPath;
    }
}

