/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import de.retest.recheck.RecheckAdapter;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.RetestIdProviderUtil;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.web.AttributesProvider;
import de.retest.web.DefaultWebValueFinder;
import de.retest.web.PeerConverter;
import de.retest.web.ScreenshotProvider;
import de.retest.web.selenium.RecheckDriver;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecheckSeleniumAdapter
implements RecheckAdapter {
    public static final RetestIdProvider idProvider = RetestIdProviderUtil.getConfiguredRetestIdProvider();
    private static final String GET_ALL_ELEMENTS_BY_PATH_JS_PATH = "/javascript/getAllElementsByPath.js";
    private static final Logger logger = LoggerFactory.getLogger(RecheckSeleniumAdapter.class);
    private final DefaultValueFinder defaultValueFinder = new DefaultWebValueFinder();

    public RecheckSeleniumAdapter() {
        logger.debug("New RecheckSeleniumAdapter created: {}.", (Object)System.identityHashCode(this));
    }

    public boolean canCheck(Object toVerify) {
        return toVerify instanceof WebDriver;
    }

    public Set<RootElement> convert(Object toVerify) {
        WebDriver driver = (WebDriver)toVerify;
        logger.info("Retrieving attributes for each element.");
        List<String> cssAttributes = AttributesProvider.getInstance().getCssAttributes();
        JavascriptExecutor jsExecutor = (JavascriptExecutor)driver;
        Map result = (Map)jsExecutor.executeScript(this.getQueryJS(), new Object[]{cssAttributes});
        logger.info("Checking website {} with {} elements.", (Object)driver.getCurrentUrl(), (Object)result.size());
        RootElement lastChecked = this.convertToPeers(result, driver.getTitle(), ScreenshotProvider.shootFullPage(driver));
        if (driver instanceof RecheckDriver) {
            ((RecheckDriver)driver).setLastActualState(lastChecked);
        }
        return Collections.singleton(lastChecked);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getQueryJS() {
        try (InputStream url = this.getClass().getResourceAsStream(GET_ALL_ELEMENTS_BY_PATH_JS_PATH);){
            String string = String.join((CharSequence)"\n", IOUtils.readLines((InputStream)url, (Charset)StandardCharsets.UTF_8));
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Exception reading '/javascript/getAllElementsByPath.js'.", e);
        }
    }

    public RootElement convertToPeers(Map<String, Map<String, Object>> data, String title, BufferedImage screenshot) {
        return new PeerConverter(idProvider, data, title, screenshot, this.defaultValueFinder).convertToPeers();
    }

    public DefaultValueFinder getDefaultValueFinder() {
        return this.defaultValueFinder;
    }
}

