/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import de.retest.web.WebData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class WebDataFilter {
    static final Set<String> specialTags = new HashSet<String>(Arrays.asList("meta", "option", "title"));

    private WebDataFilter() {
    }

    public static boolean shouldIgnore(WebData webData) {
        return WebDataFilter.isNotShown(webData) && WebDataFilter.isNotSpecialTag(webData);
    }

    private static boolean isNotShown(WebData webData) {
        return !webData.isShown();
    }

    private static boolean isNotSpecialTag(WebData webData) {
        String lowerCaseTag = webData.getTag().toLowerCase();
        return !specialTags.contains(lowerCaseTag);
    }
}

