/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.web.selenium.By;
import de.retest.web.selenium.NoElementWithReTestIdFoundException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByBestMatchToRetestId
extends org.openqa.selenium.By
implements Serializable {
    private static final long serialVersionUID = -3787115401615364934L;
    private static final Logger logger = LoggerFactory.getLogger(ByBestMatchToRetestId.class);
    private final String retestId;

    public ByBestMatchToRetestId(String retestId) {
        this.retestId = retestId;
        if (StringUtils.isBlank((CharSequence)retestId)) {
            throw new IllegalArgumentException("retestId must not be empty.");
        }
    }

    public List<WebElement> findElements(SearchContext context) {
        logger.info("findElements called with {} of {}.", (Object)context, context.getClass());
        throw new UnsupportedOperationException("This class can only be used in conjunction with a RecheckDriver.");
    }

    public Element findElement(RootElement lastExpectedState, RootElement lastActualState) {
        Element result = By.findElement(lastExpectedState, lastActualState, element -> this.retestId.equals(element.getRetestId()));
        if (result == null) {
            throw new NoElementWithReTestIdFoundException(this.retestId);
        }
        return result;
    }

    public int hashCode() {
        return this.retestId.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.retestId.equals(((ByBestMatchToRetestId)other).retestId);
    }
}

