/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.web.RecheckWebImpl;
import de.retest.web.selenium.ByBestMatchToRetestId;
import de.retest.web.selenium.TestHealer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.remote.RemoteWebDriver;

public class RecheckDriver
implements WebDriver,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByCssSelector,
FindsByTagName,
FindsByXPath,
HasInputDevices,
HasCapabilities,
Interactive,
TakesScreenshot {
    private final RemoteWebDriver wrapped;
    private RootElement lastExpectedState;
    private RootElement lastActualState;

    public RecheckDriver(RemoteWebDriver wrapped) {
        this.wrapped = wrapped;
    }

    public void setLastExpectedState(RootElement lastExpectedState) {
        this.lastExpectedState = lastExpectedState;
    }

    public RootElement getLastExpectedState() {
        return this.lastExpectedState;
    }

    public void setLastActualState(RootElement lastActualState) {
        this.lastActualState = lastActualState;
    }

    public RootElement getLastActualState() {
        return this.lastActualState;
    }

    public WebElement findElement(ByBestMatchToRetestId by) {
        if (this.lastExpectedState == null) {
            throw new IllegalStateException("You must use the " + RecheckWebImpl.class.getSimpleName() + " and first check the state before being able to use the retest ID locator.");
        }
        Element searchedFor = by.findElement(this.lastExpectedState, this.lastActualState);
        return this.wrapped.findElement(By.xpath((String)searchedFor.getIdentifyingAttributes().getPath()));
    }

    public WebElement findElementByRetestId(String retestId) {
        return this.findElement(new ByBestMatchToRetestId(retestId));
    }

    public WebElement findElement(By by) {
        if (by instanceof ByBestMatchToRetestId) {
            return this.findElement((ByBestMatchToRetestId)by);
        }
        try {
            return this.wrapped.findElement(by);
        }
        catch (NoSuchElementException e) {
            WebElement matchedOld = TestHealer.findElement(by, this);
            if (matchedOld == null) {
                throw e;
            }
            return matchedOld;
        }
    }

    public List<WebElement> findElements(By by) {
        return this.wrapped.findElements(by);
    }

    public WebElement findElementById(String using) {
        return this.wrapped.findElementById(using);
    }

    public List<WebElement> findElementsById(String using) {
        return this.wrapped.findElementsById(using);
    }

    public WebElement findElementByClassName(String using) {
        return this.wrapped.findElementByClassName(using);
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.wrapped.findElementsByClassName(using);
    }

    public WebElement findElementByLinkText(String using) {
        return this.wrapped.findElementByLinkText(using);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.wrapped.findElementsByLinkText(using);
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.wrapped.findElementByPartialLinkText(using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.wrapped.findElementsByPartialLinkText(using);
    }

    public WebElement findElementByName(String using) {
        return this.wrapped.findElementByName(using);
    }

    public List<WebElement> findElementsByName(String using) {
        return this.wrapped.findElementsByName(using);
    }

    public WebElement findElementByCssSelector(String using) {
        return this.wrapped.findElementByCssSelector(using);
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.wrapped.findElementsByCssSelector(using);
    }

    public WebElement findElementByTagName(String using) {
        return this.wrapped.findElementByTagName(using);
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.wrapped.findElementsByTagName(using);
    }

    public WebElement findElementByXPath(String using) {
        return this.wrapped.findElementByXPath(using);
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.wrapped.findElementsByXPath(using);
    }

    public void close() {
        this.wrapped.close();
    }

    public void get(String url) {
        this.wrapped.get(url);
    }

    public String getCurrentUrl() {
        return this.wrapped.getCurrentUrl();
    }

    public String getPageSource() {
        return this.wrapped.getPageSource();
    }

    public String getTitle() {
        return this.wrapped.getTitle();
    }

    public String getWindowHandle() {
        return this.wrapped.getWindowHandle();
    }

    public Set<String> getWindowHandles() {
        return this.wrapped.getWindowHandles();
    }

    public WebDriver.Options manage() {
        return this.wrapped.manage();
    }

    public WebDriver.Navigation navigate() {
        return this.wrapped.navigate();
    }

    public void quit() {
        this.wrapped.quit();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.wrapped.switchTo();
    }

    public Object executeScript(String script, Object ... args) {
        return this.wrapped.executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.wrapped.executeAsyncScript(script, args);
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        return (X)this.wrapped.getScreenshotAs(target);
    }

    public Keyboard getKeyboard() {
        return this.wrapped.getKeyboard();
    }

    public Mouse getMouse() {
        return this.wrapped.getMouse();
    }

    public Capabilities getCapabilities() {
        return this.wrapped.getCapabilities();
    }

    public void perform(Collection<Sequence> actions) {
        this.wrapped.perform(actions);
    }

    public void resetInputState() {
        this.wrapped.resetInputState();
    }
}

