/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.web.selenium.By;
import de.retest.web.selenium.ByWhisperer;
import de.retest.web.selenium.RecheckDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHealer {
    private static final Logger logger = LoggerFactory.getLogger(TestHealer.class);
    private final RecheckDriver wrapped;
    private final RootElement lastExpectedState;
    private final RootElement lastActualState;

    public TestHealer(RecheckDriver wrapped) {
        this.wrapped = wrapped;
        this.lastExpectedState = wrapped.getLastExpectedState();
        this.lastActualState = wrapped.getLastActualState();
    }

    public static WebElement findElement(org.openqa.selenium.By by, RecheckDriver wrapped) {
        return new TestHealer(wrapped).findElement(by);
    }

    private WebElement findElement(org.openqa.selenium.By by) {
        if (by instanceof By.ById) {
            return this.findElementById((By.ById)by);
        }
        if (by instanceof By.ByClassName) {
            return this.findElementByClassName((By.ByClassName)by);
        }
        if (by instanceof By.ByName) {
            return this.findElementByName((By.ByName)by);
        }
        if (by instanceof By.ByLinkText) {
            return this.findElementByLinkText((By.ByLinkText)by);
        }
        if (by instanceof By.ByCssSelector) {
            return this.findElementByCssSelector((By.ByCssSelector)by);
        }
        if (by instanceof By.ByXPath) {
            return this.findElementByXPath((By.ByXPath)by);
        }
        throw new UnsupportedOperationException("Healing tests with " + by.getClass().getSimpleName() + " not yet implemented");
    }

    private WebElement findElementById(By.ById by) {
        String id = ByWhisperer.retrieveId(by);
        Element actualElement = By.findElementByAttribute(this.lastExpectedState, this.lastActualState, "id", id);
        if (actualElement == null) {
            logger.warn("It appears that even the old state didn't have an element with id '{}'.", (Object)id);
            return null;
        }
        this.writeWarnLogForChangedIdentifier("HTML id attribute", id, actualElement.getIdentifyingAttributes().get("id"), "id", actualElement.getRetestId());
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    private WebElement findElementByClassName(By.ByClassName by) {
        String className = ByWhisperer.retrieveCSSClassName(by);
        Element actualElement = By.findElementByAttribute(this.lastExpectedState, this.lastActualState, "class", value -> ((String)value).contains(className));
        if (actualElement == null) {
            logger.warn("It appears that even the old state didn't have an element with CSS class '{}'.", (Object)className);
            return null;
        }
        this.writeWarnLogForChangedIdentifier("HTML class attribute", className, actualElement.getIdentifyingAttributes().get("class"), "className", actualElement.getRetestId());
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    private WebElement findElementByName(By.ByName by) {
        String name = ByWhisperer.retrieveName(by);
        Element actualElement = By.findElementByAttribute(this.lastExpectedState, this.lastActualState, "name", name);
        if (actualElement == null) {
            logger.warn("It appears that even the old state didn't have an element with name '{}'.", (Object)name);
            return null;
        }
        this.writeWarnLogForChangedIdentifier("HTML name attribute", name, actualElement.getAttributes().get("name"), "name", actualElement.getRetestId());
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    private WebElement findElementByLinkText(By.ByLinkText by) {
        String linkText = ByWhisperer.retrieveLinkText(by);
        String attributeName = "text";
        Element actualElement = By.findElement(this.lastExpectedState, this.lastActualState, element -> linkText.equals(element.getAttributes().get("text")) || linkText.equals(element.getIdentifyingAttributes().get("text")) && "a".equalsIgnoreCase(element.getIdentifyingAttributes().getType()));
        if (actualElement == null) {
            logger.warn("It appears that even the old state didn't have an element with link text '{}'.", (Object)linkText);
            return null;
        }
        this.writeWarnLogForChangedIdentifier("link text", linkText, actualElement.getIdentifyingAttributes().get("text"), "linkText", actualElement.getRetestId());
        return this.wrapped.findElement(org.openqa.selenium.By.xpath((String)actualElement.getIdentifyingAttributes().getPath()));
    }

    private WebElement findElementByCssSelector(By.ByCssSelector by) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private WebElement findElementByXPath(By.ByXPath byXPath) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void writeWarnLogForChangedIdentifier(String elementIdentifier, Object oldValue, Object newValue, String byMethodName, String retestId) {
        logger.warn("*************** recheck warning ***************");
        logger.warn("The {} used for element identification changed from '{}' to '{}'.", new Object[]{elementIdentifier, oldValue, newValue});
        logger.warn("retest identified the element based on the persisted old state.");
        logger.warn("If you apply these changes to the state {}, your test {} will break.", (Object)"", (Object)"");
        if (newValue != null) {
            logger.warn("Use `By.{}(\"{}\")` or `By.retestId(\"{}\")` to update your test.", new Object[]{byMethodName, newValue, retestId});
        } else {
            logger.warn("Use `By.retestId(\"{}\")` to update your test.", (Object)retestId);
        }
    }
}

