/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web;

import de.retest.recheck.RecheckAdapter;
import de.retest.recheck.RecheckOptions;
import de.retest.recheck.meta.MetadataProvider;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.idproviders.RetestIdProvider;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.web.DefaultWebValueFinder;
import de.retest.web.FrameConverter;
import de.retest.web.PeerConverter;
import de.retest.web.RecheckWebOptions;
import de.retest.web.RecheckWebProperties;
import de.retest.web.mapping.PathsToWebDataMapping;
import de.retest.web.meta.SeleniumMetadataProvider;
import de.retest.web.screenshot.ScreenshotProvider;
import de.retest.web.screenshot.ScreenshotProviders;
import de.retest.web.selenium.AutocheckingRecheckDriver;
import de.retest.web.selenium.ImplicitDriverWrapper;
import de.retest.web.selenium.UnbreakableDriver;
import de.retest.web.selenium.WriteToResultWarningConsumer;
import de.retest.web.util.SeleniumWrapperUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecheckSeleniumAdapter
implements RecheckAdapter {
    private static final String GET_ALL_ELEMENTS_BY_PATH_JS_PATH = "/javascript/getAllElementsByPath.js";
    private static final Logger logger = LoggerFactory.getLogger(RecheckSeleniumAdapter.class);
    private final DefaultValueFinder defaultValueFinder = new DefaultWebValueFinder();
    private final RetestIdProvider retestIdProvider;
    private final ScreenshotProvider screenshotProvider;
    private ActionReplayResult actionReplayResult;

    public RecheckSeleniumAdapter(RecheckOptions options) {
        this.retestIdProvider = options.getRetestIdProvider();
        this.screenshotProvider = this.getScreenshotProvider(options);
    }

    private ScreenshotProvider getScreenshotProvider(RecheckOptions options) {
        ScreenshotProvider fromOptions;
        if (options instanceof RecheckWebOptions && (fromOptions = ((RecheckWebOptions)options).getScreenshotProvider()) != null) {
            return fromOptions;
        }
        return RecheckWebProperties.getInstance().screenshotProvider();
    }

    public RecheckSeleniumAdapter() {
        this(RecheckWebOptions.builder().build());
    }

    public RecheckAdapter initialize(RecheckOptions opts) {
        return new RecheckSeleniumAdapter(opts);
    }

    public boolean canCheck(Object toVerify) {
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.ELEMENT, toVerify)) {
            return this.canCheck(SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.ELEMENT, toVerify));
        }
        if (toVerify instanceof RemoteWebElement) {
            return true;
        }
        if (toVerify instanceof UnbreakableDriver) {
            return true;
        }
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.DRIVER, toVerify)) {
            return this.canCheck(SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.DRIVER, toVerify));
        }
        return toVerify instanceof RemoteWebDriver;
    }

    public Set<RootElement> convert(Object toVerify) {
        RemoteWebElement webElement = this.retrieveWebElement(toVerify);
        if (webElement != null) {
            return this.convertWebElement(webElement);
        }
        WebDriver webDriver = this.retrieveWebDriver(this.unwrapImplicitDriver(toVerify));
        if (webDriver != null) {
            return this.convertWebDriver(webDriver);
        }
        throw new IllegalArgumentException("Cannot convert objects of type '" + toVerify.getClass().getName() + "'.");
    }

    private RemoteWebElement retrieveWebElement(Object toVerify) {
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.ELEMENT, toVerify)) {
            return this.retrieveWebElement(SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.ELEMENT, toVerify));
        }
        if (toVerify instanceof RemoteWebElement) {
            return (RemoteWebElement)toVerify;
        }
        return null;
    }

    private Object unwrapImplicitDriver(Object toVerify) {
        if (toVerify instanceof AutocheckingRecheckDriver) {
            throw new UnsupportedOperationException(String.format("The '%s' does implicit checking after each action, therefore no explicit check with 'Recheck#check' is needed. Please remove the explicit check. For more information, please have a look at https://docs.retest.de/recheck-web/introduction/usage/.", toVerify.getClass().getSimpleName()));
        }
        if (toVerify instanceof ImplicitDriverWrapper) {
            return ((ImplicitDriverWrapper)toVerify).getWrappedDriver();
        }
        return toVerify;
    }

    private WebDriver retrieveWebDriver(Object toVerify) {
        if (toVerify instanceof UnbreakableDriver) {
            return (UnbreakableDriver)toVerify;
        }
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.DRIVER, toVerify)) {
            return this.retrieveWebDriver(SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.DRIVER, toVerify));
        }
        if (toVerify instanceof RemoteWebDriver) {
            return (RemoteWebDriver)toVerify;
        }
        return null;
    }

    Set<RootElement> convertWebDriver(WebDriver driver) {
        logger.info("Retrieving attributes for each element.");
        return this.convert(driver, null);
    }

    Set<RootElement> convertWebElement(RemoteWebElement webElement) {
        logger.info("Retrieving attributes for element '{}'.", (Object)webElement);
        return this.convert(webElement.getWrappedDriver(), webElement);
    }

    private Set<RootElement> convert(WebDriver driver, RemoteWebElement webElement) {
        BufferedImage screenshot = ScreenshotProviders.shoot(driver, (WebElement)webElement, this.screenshotProvider);
        JavascriptExecutor jsExecutor = (JavascriptExecutor)driver;
        Object result = jsExecutor.executeScript(this.getQueryJS(), new Object[]{webElement});
        List tagMapping = (List)result;
        this.debugLogPseudoElements(tagMapping);
        RootElement lastChecked = this.convert(tagMapping, driver.getCurrentUrl(), driver.getTitle(), screenshot);
        FrameConverter frameConverter = new FrameConverter(this.getQueryJS(), this.retestIdProvider, this.defaultValueFinder);
        frameConverter.addChildrenFromFrames(driver, lastChecked);
        if (driver instanceof UnbreakableDriver) {
            ((UnbreakableDriver)driver).setLastActualState(lastChecked);
            ((UnbreakableDriver)driver).setWarningConsumer(new WriteToResultWarningConsumer(this::retrieveDifferences));
        }
        return Collections.singleton(lastChecked);
    }

    private void debugLogPseudoElements(List<List<Object>> tagMapping) {
        if (logger.isDebugEnabled()) {
            tagMapping.stream().filter(entry -> ((String)entry.get(0)).contains("pseudo")).forEach(entry -> logger.debug("{} | {}", entry.get(0), entry.get(1)));
        }
    }

    public RootElement convert(List<List<Object>> tagMapping, String url, String title, BufferedImage screenshot) {
        PathsToWebDataMapping mapping = new PathsToWebDataMapping(tagMapping);
        logger.info("Checking website {} with {} elements.", (Object)url, (Object)mapping.size());
        return new PeerConverter(this.retestIdProvider, mapping, title, screenshot, this.defaultValueFinder, mapping.getRootPath()).convertToPeers();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getQueryJS() {
        try (InputStream url = this.getClass().getResourceAsStream(GET_ALL_ELEMENTS_BY_PATH_JS_PATH);){
            String string = String.join((CharSequence)"\n", IOUtils.readLines((InputStream)url, (Charset)StandardCharsets.UTF_8));
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Exception reading '/javascript/getAllElementsByPath.js'.", e);
        }
    }

    private Stream<ElementDifference> retrieveDifferences() {
        if (this.actionReplayResult == null) {
            return Stream.empty();
        }
        return this.actionReplayResult.getAllElementDifferences().stream();
    }

    public Map<String, String> retrieveMetadata(Object toCheck) {
        MetadataProvider provider = SeleniumMetadataProvider.of(toCheck);
        return provider.retrieve();
    }

    public DefaultValueFinder getDefaultValueFinder() {
        return this.defaultValueFinder;
    }

    public void notifyAboutDifferences(ActionReplayResult actionReplayResult) {
        this.actionReplayResult = actionReplayResult;
    }
}

