/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.mapping;

import de.retest.web.mapping.WebData;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PathsToWebDataMapping
implements Iterable<Map.Entry<String, WebData>> {
    private final LinkedHashMap<String, WebData> mapping;
    private final String rootPath;

    public PathsToWebDataMapping(List<List<Object>> mapping) {
        this("/", mapping);
    }

    public PathsToWebDataMapping(String frameParentPath, List<List<Object>> mapping) {
        this.rootPath = frameParentPath + this.extractRootPath(mapping);
        this.mapping = this.convertMapping(frameParentPath, mapping);
    }

    private LinkedHashMap<String, WebData> convertMapping(String frameParentPath, List<List<Object>> mapping) {
        LinkedHashMap<String, WebData> result = new LinkedHashMap<String, WebData>();
        for (List<Object> list : mapping) {
            result.put(frameParentPath + list.get(0).toString().replace("//", "/"), new WebData((Map)list.get(1)));
        }
        return result;
    }

    private String extractRootPath(List<List<Object>> mapping) {
        String rootPath = null;
        for (List<Object> entry : mapping) {
            if (rootPath == null) {
                rootPath = entry.get(0).toString();
                continue;
            }
            if (StringUtils.countMatches((CharSequence)entry.get(0).toString(), (CharSequence)"/") >= StringUtils.countMatches((CharSequence)rootPath, (CharSequence)"/")) continue;
            rootPath = entry.get(0).toString();
        }
        return rootPath != null ? rootPath.replace("//", "/") : "";
    }

    public int size() {
        return this.mapping.size();
    }

    public WebData getWebData(String path) {
        return this.mapping.get(path);
    }

    @Override
    public Iterator<Map.Entry<String, WebData>> iterator() {
        return this.mapping.entrySet().iterator();
    }

    public String getRootPath() {
        return this.rootPath;
    }
}

