/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.screenshot;

import com.assertthat.selenium_shutterbug.core.Shutterbug;
import de.retest.recheck.ui.image.ImageUtils;
import de.retest.web.screenshot.ScreenshotProvider;
import java.awt.image.BufferedImage;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ViewportOnlyMinimalScreenshot
implements ScreenshotProvider {
    static final int DEFAULT_WANTED_WIDTH_PX = 800;
    private static final String RESIZE_MAX_WIDTH_PX = "de.retest.recheck.web.screenshot.maxWidthPx";
    private static final int WANTED_WIDTH = Integer.getInteger("de.retest.recheck.web.screenshot.maxWidthPx", 800);
    private static final boolean USE_DEVICE_PIXEL_RATIO = true;

    @Override
    public BufferedImage shoot(WebDriver driver) {
        return ViewportOnlyMinimalScreenshot.resizeImage(Shutterbug.shootPage((WebDriver)driver, (boolean)true).getImage());
    }

    @Override
    public BufferedImage shoot(WebDriver driver, WebElement element) {
        return ViewportOnlyMinimalScreenshot.resizeImage(Shutterbug.shootElement((WebDriver)driver, (WebElement)element, (boolean)true).getImage());
    }

    public static BufferedImage resizeImage(BufferedImage image) {
        if (image.getWidth() <= WANTED_WIDTH) {
            return image;
        }
        double height = (double)image.getHeight() * ((double)WANTED_WIDTH / (double)image.getWidth());
        return ImageUtils.resizeImage((BufferedImage)image, (int)WANTED_WIDTH, (int)((int)height));
    }
}

