/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import de.retest.recheck.RecheckLifecycle;
import de.retest.recheck.RecheckOptions;
import de.retest.web.RecheckWebImpl;
import de.retest.web.RecheckWebOptions;
import de.retest.web.selenium.AutocheckingCheckNamingStrategy;
import de.retest.web.selenium.AutocheckingNavigationWrapper;
import de.retest.web.selenium.AutocheckingTargetLocator;
import de.retest.web.selenium.AutocheckingWebElement;
import de.retest.web.selenium.ByBestMatchToRetestId;
import de.retest.web.selenium.ImplicitDriverWrapper;
import de.retest.web.selenium.UnbreakableDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class AutocheckingRecheckDriver
extends UnbreakableDriver
implements RecheckLifecycle {
    private RecheckWebImpl re;
    private final RecheckOptions options;
    private final AutocheckingCheckNamingStrategy checkNamingStrategy;
    private final long autocheckingDelayMillis;

    public AutocheckingRecheckDriver(RemoteWebDriver wrapped) {
        this(wrapped, RecheckWebOptions.builder().build());
    }

    public AutocheckingRecheckDriver(RemoteWebDriver wrapped, RecheckOptions options) {
        super(wrapped);
        this.options = options;
        RecheckWebOptions webOptions = options instanceof RecheckWebOptions ? (RecheckWebOptions)options : RecheckWebOptions.builder().build();
        this.checkNamingStrategy = webOptions.getCheckNamingStrategy();
        this.autocheckingDelayMillis = webOptions.getAutocheckingDelayMillis();
    }

    @Deprecated
    public AutocheckingRecheckDriver(RemoteWebDriver wrapped, RecheckOptions options, AutocheckingCheckNamingStrategy checkNamingStrategy) {
        super(wrapped);
        this.options = options;
        this.checkNamingStrategy = checkNamingStrategy;
        this.autocheckingDelayMillis = RecheckWebOptions.builder().build().getAutocheckingDelayMillis();
    }

    public void startTest() {
        this.checkNamingStrategy.nextTest();
        if (this.re == null) {
            this.re = new RecheckWebImpl(this.options);
        }
        this.re.startTest();
    }

    public void startTest(String testName) {
        if (this.re == null) {
            this.re = new RecheckWebImpl(this.options);
        }
        this.re.startTest(testName);
    }

    public void capTest() {
        this.re.capTest();
    }

    public void cap() {
        this.checkNamingStrategy.nextTest();
        this.re.cap();
    }

    @Override
    public void get(String url) {
        super.get(url);
        this.check("get", null, new Object[0]);
    }

    @Override
    public void close() {
        super.close();
        this.ifBrowserIsNotRunning(this::cap);
    }

    @Override
    public void quit() {
        try {
            this.cap();
        }
        finally {
            super.quit();
        }
    }

    private void ifBrowserIsNotRunning(Runnable call) {
        try {
            super.getWindowHandles();
        }
        catch (NullPointerException | NoSuchSessionException e) {
            call.run();
        }
    }

    @Override
    protected WebElement wrap(WebElement element) {
        return AutocheckingWebElement.of(element, this);
    }

    @Override
    public AutocheckingWebElement findElement(ByBestMatchToRetestId by) {
        WebElement wrapped = super.findElement(by);
        String result = wrapped.toString();
        result = result.substring(0, result.lastIndexOf(" -> xpath: "));
        String representation = result + " -> retestId: " + by.getRetestId() + "]";
        return AutocheckingWebElement.of(wrapped, this, representation);
    }

    @Override
    public AutocheckingWebElement findElement(By by) {
        return (AutocheckingWebElement)super.findElement(by);
    }

    void check(String action, WebElement target, Object ... params) {
        if (this.re == null) {
            this.startTest();
        }
        this.waitAutocheckingDelay();
        this.re.check(ImplicitDriverWrapper.of(this), this.checkNamingStrategy.getUniqueCheckName(action, target, params));
    }

    public void check(String action) {
        if (this.re == null) {
            this.startTest();
        }
        this.waitAutocheckingDelay();
        this.re.check(ImplicitDriverWrapper.of(this), this.checkNamingStrategy.getUniqueCheckName(action));
    }

    void waitAutocheckingDelay() {
        if (this.autocheckingDelayMillis > 0L) {
            try {
                Thread.sleep(this.autocheckingDelayMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public WebDriver.Navigation navigate() {
        return new AutocheckingNavigationWrapper(super.navigate(), this);
    }

    @Override
    public WebDriver.TargetLocator switchTo() {
        return new AutocheckingTargetLocator(super.switchTo(), this);
    }
}

