/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.web.selenium.ByBestMatchToRetestId;
import de.retest.web.selenium.QualifiedElementWarning;
import de.retest.web.selenium.TestHealer;
import de.retest.web.selenium.WrappingWebElement;
import de.retest.web.util.SeleniumWrapperUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Pdf;
import org.openqa.selenium.PrintsPage;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.print.PrintOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.virtualauthenticator.HasVirtualAuthenticator;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticator;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticatorOptions;

public class UnbreakableDriver
implements WebDriver,
JavascriptExecutor,
HasInputDevices,
HasCapabilities,
HasVirtualAuthenticator,
Interactive,
PrintsPage,
TakesScreenshot,
WrapsDriver {
    private final RemoteWebDriver wrappedDriver;
    private RootElement lastExpectedState;
    private RootElement lastActualState;
    private Consumer<QualifiedElementWarning> warningConsumer;

    public UnbreakableDriver(RemoteWebDriver wrappedDriver) {
        this.wrappedDriver = wrappedDriver;
    }

    public WebElement findElement(ByBestMatchToRetestId by) {
        Element searchedFor = by.findElement(this.lastExpectedState, this.lastActualState);
        WebElement element = this.wrappedDriver.findElement(By.xpath((String)searchedFor.getIdentifyingAttributes().getPath()));
        return this.wrap(element);
    }

    protected WebElement wrap(WebElement element) {
        return WrappingWebElement.wrap(this, element);
    }

    private List<WebElement> wrap(List<WebElement> elements) {
        return elements.stream().map(this::wrap).collect(Collectors.toList());
    }

    public WebElement findElementByRetestId(String retestId) {
        return this.findElement(new ByBestMatchToRetestId(retestId));
    }

    public WebElement findElement(By by) {
        if (by instanceof ByBestMatchToRetestId) {
            return this.findElement((ByBestMatchToRetestId)by);
        }
        try {
            return this.wrap(this.wrappedDriver.findElement(by));
        }
        catch (NoSuchElementException e) {
            WebElement matchedOld = TestHealer.findElement(by, this);
            if (matchedOld == null) {
                throw e;
            }
            return this.wrap(matchedOld);
        }
    }

    public List<WebElement> findElements(By by) {
        return this.wrap(this.wrappedDriver.findElements(by));
    }

    public void close() {
        this.wrappedDriver.close();
    }

    public void get(String url) {
        this.wrappedDriver.get(url);
    }

    public String getCurrentUrl() {
        return this.wrappedDriver.getCurrentUrl();
    }

    public String getPageSource() {
        return this.wrappedDriver.getPageSource();
    }

    public String getTitle() {
        return this.wrappedDriver.getTitle();
    }

    public String getWindowHandle() {
        return this.wrappedDriver.getWindowHandle();
    }

    public Set<String> getWindowHandles() {
        return this.wrappedDriver.getWindowHandles();
    }

    public WebDriver.Options manage() {
        return this.wrappedDriver.manage();
    }

    public WebDriver.Navigation navigate() {
        return this.wrappedDriver.navigate();
    }

    public void quit() {
        this.wrappedDriver.quit();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.wrappedDriver.switchTo();
    }

    public Object executeScript(String script, Object ... args) {
        return this.wrappedDriver.executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.wrappedDriver.executeAsyncScript(script, args);
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        return (X)this.wrappedDriver.getScreenshotAs(target);
    }

    public Keyboard getKeyboard() {
        return this.wrappedDriver.getKeyboard();
    }

    public Mouse getMouse() {
        return this.wrappedDriver.getMouse();
    }

    public Capabilities getCapabilities() {
        return this.wrappedDriver.getCapabilities();
    }

    public void perform(Collection<Sequence> actions) {
        this.wrappedDriver.perform(actions);
    }

    public void resetInputState() {
        this.wrappedDriver.resetInputState();
    }

    public Pdf print(PrintOptions printOptions) throws WebDriverException {
        return this.wrappedDriver.print(printOptions);
    }

    public VirtualAuthenticator addVirtualAuthenticator(VirtualAuthenticatorOptions options) {
        return this.wrappedDriver.addVirtualAuthenticator(options);
    }

    public void removeVirtualAuthenticator(VirtualAuthenticator authenticator) {
        this.wrappedDriver.removeVirtualAuthenticator(authenticator);
    }

    public WebDriver getWrappedDriver() {
        if (SeleniumWrapperUtil.isWrapper(SeleniumWrapperUtil.WrapperOf.DRIVER, this.wrappedDriver)) {
            return SeleniumWrapperUtil.getWrapped(SeleniumWrapperUtil.WrapperOf.DRIVER, this.wrappedDriver);
        }
        return this.wrappedDriver;
    }

    public WebDriver skipCheck() {
        return this.getWrappedDriver();
    }

    public RootElement getLastExpectedState() {
        return this.lastExpectedState;
    }

    public RootElement getLastActualState() {
        return this.lastActualState;
    }

    public Consumer<QualifiedElementWarning> getWarningConsumer() {
        return this.warningConsumer;
    }

    public void setLastExpectedState(RootElement lastExpectedState) {
        this.lastExpectedState = lastExpectedState;
    }

    public void setLastActualState(RootElement lastActualState) {
        this.lastActualState = lastActualState;
    }

    public void setWarningConsumer(Consumer<QualifiedElementWarning> warningConsumer) {
        this.warningConsumer = warningConsumer;
    }
}

