/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.selenium;

import de.retest.recheck.ui.diff.AttributeDifference;
import de.retest.recheck.ui.diff.ElementDifference;
import de.retest.recheck.ui.diff.ElementIdentificationWarning;
import de.retest.web.selenium.QualifiedElementWarning;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class WriteToResultWarningConsumer
implements Consumer<QualifiedElementWarning> {
    private final ElementDifferenceRetriever retriever;

    @Override
    public void accept(QualifiedElementWarning warning) {
        this.retriever.getDifferences().filter(this.matchesRetestId(warning.getRetestId())).map(ElementDifference::getAttributeDifferences).flatMap(Collection::stream).filter(this.matchesAttributeKey(warning.getAttributeKey())).forEach(this.addWarning(warning.getWarning()));
    }

    private Predicate<ElementDifference> matchesRetestId(String retestId) {
        return difference -> difference.getRetestId().equals(retestId);
    }

    private Predicate<AttributeDifference> matchesAttributeKey(String attributeKey) {
        return difference -> difference.getKey().equals(attributeKey);
    }

    private Consumer<AttributeDifference> addWarning(ElementIdentificationWarning warning) {
        return difference -> difference.addElementIdentificationWarning(warning);
    }

    public WriteToResultWarningConsumer(ElementDifferenceRetriever retriever) {
        this.retriever = retriever;
    }

    @FunctionalInterface
    public static interface ElementDifferenceRetriever {
        public Stream<ElementDifference> getDifferences();
    }
}

