/*
 * Decompiled with CFR 0.152.
 */
package de.retest.web.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumWrapperUtil {
    public static boolean isWrapper(WrapperOf<?> w, Object o) {
        return SeleniumWrapperUtil.getWrapperClass(w, o) != null;
    }

    public static <T> T getWrapped(WrapperOf<? extends T> w, Object o) {
        Object wrapped;
        Class<T> wrappedClass = w.getWrappedClass();
        Class<?> clazz = SeleniumWrapperUtil.getWrapperClass(w, o);
        if (clazz == null) {
            throw new IllegalArgumentException("Type '" + o.getClass() + "' is not instance of any of " + Arrays.toString(w.getWrapperClassNames()) + ".");
        }
        try {
            wrapped = clazz.getMethod(w.getWrapperMethodName(), new Class[0]).invoke(o, new Object[0]);
            if (wrapped == null) {
                return null;
            }
            if (wrappedClass.isInstance(wrapped)) {
                return wrappedClass.cast(wrapped);
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke " + o.getClass().getSimpleName() + "#" + w.getWrapperMethodName() + ".", e.getTargetException());
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new UnsupportedOperationException("Failed to invoke " + o.getClass().getSimpleName() + "#" + w.getWrapperMethodName() + ".", e);
        }
        throw new UnsupportedOperationException("Failed to retrieve expected type '" + wrappedClass.getSimpleName() + "' of '" + w.getWrapperMethodName() + "', got '" + wrapped.getClass().getSimpleName() + "'");
    }

    private static Class<?> getWrapperClass(WrapperOf<?> w, Object o) {
        for (String wrapsElementClassName : w.getWrapperClassNames()) {
            try {
                Class<?> clazz = Class.forName(wrapsElementClassName);
                if (!clazz.isInstance(o)) continue;
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static class WrapperOf<T> {
        public static final WrapperOf<WebElement> ELEMENT = new WrapperOf<WebElement>(WebElement.class, "getWrappedElement", new String[]{"org.openqa.selenium.WrapsElement", "org.openqa.selenium.internal.WrapsElement"});
        public static final WrapperOf<WebDriver> DRIVER = new WrapperOf<WebDriver>(WebDriver.class, "getWrappedDriver", new String[]{"org.openqa.selenium.WrapsDriver", "org.openqa.selenium.internal.WrapsDriver"});
        private final Class<? extends T> wrappedClass;
        private final String wrapperMethodName;
        private final String[] wrapperClassNames;

        public Class<? extends T> getWrappedClass() {
            return this.wrappedClass;
        }

        public String getWrapperMethodName() {
            return this.wrapperMethodName;
        }

        public String[] getWrapperClassNames() {
            return this.wrapperClassNames;
        }

        public WrapperOf(Class<? extends T> wrappedClass, String wrapperMethodName, String[] wrapperClassNames) {
            this.wrappedClass = wrappedClass;
            this.wrapperMethodName = wrapperMethodName;
            this.wrapperClassNames = wrapperClassNames;
        }
    }
}

