/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck;

import de.retest.recheck.FileNamerStrategy;
import de.retest.recheck.persistence.FileNamer;
import java.io.File;
import java.util.Objects;

public class GradleConformFileNamerStrategy
implements FileNamerStrategy {
    private final String sourceSetName;
    public static final String DEFAULT_RETEST_WORKSPACE_PATH_FORMAT = "src/%s/resources/retest/";
    public static final String DEFAULT_RETEST_TESTREPORTS_PATH_FORMAT = "build/test-results/%s/retest/";

    public GradleConformFileNamerStrategy() {
        this("test");
    }

    public GradleConformFileNamerStrategy(String sourceSetName) {
        Objects.requireNonNull(sourceSetName, "sourceSetName cannot be null!");
        if (sourceSetName.isEmpty()) {
            throw new IllegalArgumentException("sourceSetName cannot be empty!");
        }
        this.sourceSetName = sourceSetName;
    }

    @Override
    public FileNamer createFileNamer(final String ... baseNames) {
        return new FileNamer(){

            @Override
            public File getFile(String extension) {
                return GradleConformFileNamerStrategy.this.toFile(GradleConformFileNamerStrategy.DEFAULT_RETEST_WORKSPACE_PATH_FORMAT, extension, baseNames);
            }

            @Override
            public File getResultFile(String extension) {
                return GradleConformFileNamerStrategy.this.toFile(GradleConformFileNamerStrategy.DEFAULT_RETEST_TESTREPORTS_PATH_FORMAT, extension, baseNames);
            }
        };
    }

    private File toFile(String prefixFormat, String extension, String ... baseNames) {
        String baseName = String.join((CharSequence)File.separator, baseNames);
        String prefix = String.format(prefixFormat, this.sourceSetName);
        return new File(prefix + File.separator + "recheck" + File.separator + baseName + extension);
    }
}

