/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck;

import de.retest.recheck.FileNamerStrategy;
import de.retest.recheck.NoRecheckFileActionReplayResult;
import de.retest.recheck.Recheck;
import de.retest.recheck.RecheckAdapter;
import de.retest.recheck.RecheckOptions;
import de.retest.recheck.ReplayResultProvider;
import de.retest.recheck.SutStateLoader;
import de.retest.recheck.configuration.ProjectConfiguration;
import de.retest.recheck.execution.RecheckAdapters;
import de.retest.recheck.execution.RecheckDifferenceFinder;
import de.retest.recheck.ignore.RecheckIgnoreUtil;
import de.retest.recheck.persistence.FileNamer;
import de.retest.recheck.persistence.RecheckReplayResultUtil;
import de.retest.recheck.persistence.RecheckSutState;
import de.retest.recheck.printer.TestReplayResultPrinter;
import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.report.TestReplayResult;
import de.retest.recheck.review.GlobalIgnoreApplier;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.diff.LeafDifference;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecheckImpl
implements Recheck,
SutStateLoader {
    private static final String WORKSPACE_DEFAULT = "src/test/resources/retest/";
    private static final String CONFIG_PATH = "src/test/resources/retest/retest.properties";
    private static final Logger logger = LoggerFactory.getLogger(RecheckImpl.class);
    private final CapWarner capWarner = new CapWarner();
    private final SuiteReplayResult suite;
    private final FileNamerStrategy fileNamerStrategy;
    private final String suiteName;
    private TestReplayResult currentTestResult;
    private final Map<String, DefaultValueFinder> usedFinders = new HashMap<String, DefaultValueFinder>();
    private final TestReplayResultPrinter printer;
    private final GlobalIgnoreApplier ignoreApplier;

    public RecheckImpl() {
        this(RecheckOptions.builder().build());
    }

    public RecheckImpl(RecheckOptions options) {
        ProjectConfiguration.getInstance().ensureProjectConfigurationInitialized();
        RecheckImpl.ensureConfigurationInitialized();
        Runtime.getRuntime().addShutdownHook(this.capWarner);
        this.fileNamerStrategy = options.getFileNamerStrategy();
        this.suiteName = options.getSuiteName();
        this.suite = ReplayResultProvider.getInstance().getSuite(this.suiteName);
        this.ignoreApplier = RecheckIgnoreUtil.loadRecheckIgnore();
        this.printer = new TestReplayResultPrinter(this.usedFinders::get, this.ignoreApplier);
    }

    private static void ensureConfigurationInitialized() {
        if (System.getProperty("de.retest.configFile") == null) {
            System.setProperty("de.retest.configFile", CONFIG_PATH);
        }
    }

    @Override
    public void startTest() {
        this.startTest(this.fileNamerStrategy.getTestMethodName());
    }

    @Override
    public void startTest(String testName) {
        this.currentTestResult = new TestReplayResult(testName, 0);
    }

    @Override
    public void check(Object toVerify, String currentStep) {
        this.check(toVerify, RecheckAdapters.findAdapterFor(toVerify), currentStep);
    }

    @Override
    public void check(Object toVerify, RecheckAdapter adapter, String currentStep) {
        if (this.currentTestResult == null) {
            logger.warn("Please call 'startTest()' before performing a check.");
            this.startTest();
        }
        ActionReplayResult actionReplayResult = this.createActionReplayResult(toVerify, adapter, currentStep);
        this.currentTestResult.addAction(actionReplayResult);
    }

    protected ActionReplayResult createActionReplayResult(Object toVerify, RecheckAdapter adapter, String currentStep) {
        DefaultValueFinder defaultFinder = adapter.getDefaultValueFinder();
        this.usedFinders.put(currentStep, defaultFinder);
        FileNamer fileNamer = this.createFileName(currentStep);
        File file = fileNamer.getFile(".recheck");
        SutState actual = RecheckSutState.convert(toVerify, adapter);
        SutState expected = this.loadExpected(file);
        if (expected == null) {
            this.createNew(file, actual);
            return new NoRecheckFileActionReplayResult(currentStep, actual);
        }
        RecheckDifferenceFinder finder = new RecheckDifferenceFinder(adapter.getDefaultValueFinder(), currentStep, file.getPath());
        return finder.findDifferences(actual, expected);
    }

    @Override
    public SutState loadExpected(File file) {
        return RecheckSutState.loadExpected(file);
    }

    @Override
    public SutState createNew(File file, SutState actual) {
        return RecheckSutState.createNew(file, actual);
    }

    private FileNamer createFileName(String currentStep) {
        String name = this.suiteName + File.separator + this.currentTestResult.getName() + "." + currentStep;
        return this.fileNamerStrategy.createFileNamer(name);
    }

    @Override
    public void capTest() {
        this.suite.addTest(this.currentTestResult);
        TestReplayResult finishedTestResult = this.currentTestResult;
        this.currentTestResult = null;
        Set<LeafDifference> uniqueDifferences = finishedTestResult.getDifferences(this.ignoreApplier);
        if (!uniqueDifferences.isEmpty()) {
            String message = finishedTestResult.hasNoRecheckFiles() ? this.getNoRecheckFilesErrorMessage() : this.getDifferencesErrorMessage(finishedTestResult);
            throw new AssertionError((Object)message);
        }
    }

    @Override
    public void cap() {
        this.capWarner.disarm();
        try {
            if (this.currentTestResult != null) {
                logger.warn("Test {} was not finished. You should call 'capTest()' after your test, to have it fail on changes!", (Object)this.currentTestResult.getName());
                this.capTest();
            }
        }
        finally {
            File file = this.getResultFile();
            RecheckReplayResultUtil.persist(this.suite, file);
        }
    }

    public File getResultFile() {
        return this.fileNamerStrategy.createFileNamer(this.suiteName).getResultFile(".result");
    }

    private String getNoRecheckFilesErrorMessage() {
        return "'" + this.suiteName + "':\n" + "No recheck file found. First time test was run? Created recheck file now, don't forget to commit...";
    }

    private String getDifferencesErrorMessage(TestReplayResult finishedTestResult) {
        return "\nA detailed report will be created at '" + this.getResultFile() + "'. You can review the details by using our GUI from https://retest.de/review/.\n\nThe following differences have been found in '" + this.suiteName + "'(with " + finishedTestResult.getActionReplayResults().size() + " check(s)):\n" + this.printer.toString(finishedTestResult);
    }

    private class CapWarner
    extends Thread {
        private volatile boolean armed = true;

        private CapWarner() {
        }

        @Override
        public void run() {
            if (!this.armed) {
                return;
            }
            if (RecheckImpl.this.currentTestResult != null) {
                logger.warn("Test {} was not finished!", (Object)RecheckImpl.this.currentTestResult.getName());
            }
            logger.warn("You should call 'cap()' after your test '{}' has finished, to persist test results.", (Object)RecheckImpl.this.suiteName);
        }

        public void disarm() {
            this.armed = false;
            Runtime.getRuntime().removeShutdownHook(this);
        }
    }
}

