/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck;

import de.retest.recheck.report.SuiteReplayResult;
import de.retest.recheck.suite.ExecutableSuite;
import de.retest.recheck.ui.actions.ActionStateSequence;
import de.retest.recheck.ui.descriptors.GroundState;
import java.util.ArrayList;

public class ReplayResultProvider {
    private static ReplayResultProvider instance;
    private SuiteReplayResult currentSuite;

    public static ReplayResultProvider getInstance() {
        if (instance == null) {
            instance = new ReplayResultProvider();
        }
        return instance;
    }

    static ReplayResultProvider getTestInstance() {
        return new ReplayResultProvider();
    }

    private ReplayResultProvider() {
    }

    public SuiteReplayResult getSuite(String suiteName) {
        if (this.currentSuite == null) {
            this.currentSuite = this.createSuiteReplayResult(suiteName);
        }
        if (!suiteName.equals(this.currentSuite.getSuiteName())) {
            this.currentSuite = this.createSuiteReplayResult(suiteName);
        }
        return this.currentSuite;
    }

    private SuiteReplayResult createSuiteReplayResult(String suiteName) {
        GroundState groundState = new GroundState();
        ExecutableSuite execSuite = new ExecutableSuite(groundState, 0L, new ArrayList<ActionStateSequence>());
        execSuite.setName(suiteName);
        return new SuiteReplayResult(execSuite, 0, groundState);
    }
}

