/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseFinder {
    private static final Logger logger = LoggerFactory.getLogger(TestCaseFinder.class);
    private static final Set<String> testCaseAnnotations = new HashSet<String>(Arrays.asList("org.junit.Test", "org.junit.Before", "org.junit.After", "org.junit.BeforeClass", "org.junit.AfterClass", "org.junit.jupiter.api.Test", "org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll", "org.junit.jupiter.params.ParameterizedTest", "org.testng.annotations.Test", "org.testng.annotations.BeforeMethod", "org.testng.annotations.AfterMethod", "org.testng.annotations.BeforeClass", "org.testng.annotations.AfterClass"));

    private TestCaseFinder() {
    }

    public static StackTraceElement findTestCaseMethodInStack() {
        for (StackTraceElement[] stack : Thread.getAllStackTraces().values()) {
            StackTraceElement testCaseStackElement = TestCaseFinder.findTestCaseMethodInStack(stack);
            if (testCaseStackElement == null) continue;
            return testCaseStackElement;
        }
        return null;
    }

    public static StackTraceElement findTestCaseMethodInStack(StackTraceElement[] trace) {
        boolean inTestCase = false;
        for (int i = 0; i < trace.length; ++i) {
            if (TestCaseFinder.isTestCase(trace[i])) {
                inTestCase = true;
                continue;
            }
            if (!inTestCase) continue;
            return trace[i - 1];
        }
        return null;
    }

    private static boolean isTestCase(StackTraceElement element) {
        Annotation[] annotations;
        Method method = TestCaseFinder.tryToFindMethodForStackTraceElement(element);
        if (method == null) {
            return false;
        }
        for (Annotation annotation : annotations = method.getAnnotations()) {
            String annotationName = annotation.annotationType().getName();
            if (!testCaseAnnotations.contains(annotationName)) continue;
            return true;
        }
        return false;
    }

    private static Method tryToFindMethodForStackTraceElement(StackTraceElement element) {
        Class<?> clazz;
        Method method = null;
        try {
            clazz = Class.forName(element.getClassName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            for (Method methodCandidate : clazz.getDeclaredMethods()) {
                if (!methodCandidate.getName().equals(element.getMethodName())) continue;
                if (method == null) {
                    method = methodCandidate;
                    continue;
                }
                return null;
            }
        }
        catch (NoClassDefFoundError noClass) {
            logger.error("Could not analyze method due to NoClassDefFoundError: ", (Object)noClass.getMessage());
        }
        return method;
    }
}

