/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.configuration;

import de.retest.recheck.configuration.ProjectRootFinderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ProjectConfiguration.class);
    public static final String RETEST_PROJECT_CONFIG_FOLDER = ".retest";
    public static final String RETEST_PROJECT_PROPERTIES = "retest.properties";
    public static final String RECHECK_IGNORE = "recheck.ignore";
    public static final String RECHECK_IGNORE_JSRULES = "recheck.ignore.js";
    private static final String DEFAULT_PREFIX = "default-";
    private static final String RETEST_PROJECT_DEFAULTS = "default-retest.properties";
    private static final String RECHECK_IGNORE_DEFAULTS = "default-recheck.ignore";
    private static final String RECHECK_IGNORE_JSRULES_DEFAULTS = "default-recheck.ignore.js";
    private static ProjectConfiguration instance;
    public static final String RETEST_PROJECT_ROOT = "de.retest.recheck.project.root";

    private ProjectConfiguration() {
    }

    public static ProjectConfiguration getInstance() {
        if (instance == null) {
            instance = new ProjectConfiguration();
        }
        return instance;
    }

    public void ensureProjectConfigurationInitialized() {
        Path projectRoot = ProjectRootFinderUtil.getProjectRoot().orElseThrow(() -> new RuntimeException("Project root could not be found."));
        Path projectConfigFolder = projectRoot.resolve(RETEST_PROJECT_CONFIG_FOLDER);
        Path projectConfigFile = projectConfigFolder.resolve(RETEST_PROJECT_PROPERTIES);
        Path projectIgnoreFile = projectConfigFolder.resolve(RECHECK_IGNORE);
        Path projectRuleIgnoreFile = projectConfigFolder.resolve(RECHECK_IGNORE_JSRULES);
        this.createProjectConfigurationFolderIfNeeded(projectConfigFolder);
        this.createEmptyProjectConfigurationIfNeeded(projectConfigFile, RETEST_PROJECT_DEFAULTS);
        this.createEmptyProjectConfigurationIfNeeded(projectIgnoreFile, RECHECK_IGNORE_DEFAULTS);
        this.createEmptyProjectConfigurationIfNeeded(projectRuleIgnoreFile, RECHECK_IGNORE_JSRULES_DEFAULTS);
    }

    private void createProjectConfigurationFolderIfNeeded(Path configFolder) {
        if (!configFolder.toFile().exists()) {
            try {
                Files.createDirectories(configFolder, new FileAttribute[0]);
                Files.copy(this.getClass().getClassLoader().getResourceAsStream(RETEST_PROJECT_DEFAULTS), configFolder.resolve(RETEST_PROJECT_PROPERTIES), new CopyOption[0]);
                logger.info("Creating empty project configuration in {}.", (Object)configFolder);
            }
            catch (IOException e) {
                logger.error("Error creating project configuration folder in {}.", (Object)configFolder);
            }
        }
    }

    private void createEmptyProjectConfigurationIfNeeded(Path configFile, String defaultFile) {
        if (!configFile.toFile().exists()) {
            try (InputStream is = this.getInputStreamFrom(defaultFile);){
                Files.copy(is, configFile, new CopyOption[0]);
                logger.info("Creating empty recheck configuration in {}.", (Object)configFile);
            }
            catch (IOException e) {
                logger.error("Error creating empty recheck configuration in {}.", (Object)configFile);
            }
        }
    }

    private InputStream getInputStreamFrom(String fileName) {
        return this.getClass().getClassLoader().getResourceAsStream(fileName);
    }
}

