/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.configuration;

import com.google.common.collect.Sets;
import de.retest.recheck.configuration.PathBasedProjectRootFinder;
import de.retest.recheck.configuration.ProjectRootFinder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;

public class ProjectRootFinderUtil {
    private static final Set<ProjectRootFinder> projectRootFinder = Sets.newHashSet((Object[])new ProjectRootFinder[]{new PathBasedProjectRootFinder()});

    private ProjectRootFinderUtil() {
    }

    public static Optional<Path> getProjectRoot() {
        Path baseFolder = Paths.get(System.getProperty("de.retest.recheck.project.root", ""), new String[0]);
        return ProjectRootFinderUtil.getProjectRoot(baseFolder.toAbsolutePath());
    }

    public static Optional<Path> getProjectRoot(Path basePath) {
        return projectRootFinder.stream().map(finder -> finder.findProjectRoot(basePath)).filter(Optional::isPresent).map(Optional::get).findAny();
    }
}

