/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.execution;

import de.retest.recheck.report.ActionReplayResult;
import de.retest.recheck.report.action.ActionReplayData;
import de.retest.recheck.report.action.DifferenceRetriever;
import de.retest.recheck.report.action.WindowRetriever;
import de.retest.recheck.ui.DefaultValueFinder;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.ui.diff.DifferenceResult;
import de.retest.recheck.ui.diff.RootElementDifference;
import de.retest.recheck.ui.diff.RootElementDifferenceFinder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecheckDifferenceFinder {
    private static final Logger logger = LoggerFactory.getLogger(RecheckDifferenceFinder.class);
    private final RootElementDifferenceFinder finder;
    private final String currentStep;
    private final String stateFilePath;

    public RecheckDifferenceFinder(DefaultValueFinder finder, String currentStep, String stateFilePath) {
        this.finder = new RootElementDifferenceFinder(finder);
        this.currentStep = currentStep;
        this.stateFilePath = stateFilePath;
    }

    public ActionReplayResult findDifferences(SutState actual, SutState expected) {
        return this.toActionReplayResult(new DifferenceResult(actual, this.findDifferencesBetweenStates(actual, expected)));
    }

    private List<RootElementDifference> findDifferencesBetweenStates(SutState actual, SutState expected) {
        return this.finder.findDifferences(expected.getRootElements(), actual.getRootElements());
    }

    private ActionReplayResult toActionReplayResult(DifferenceResult check) {
        List<RootElementDifference> differences = check.getDifferences();
        if (differences != null && differences.size() > 0) {
            logger.info("Found {} differences for step '{}'.", (Object)differences.size(), (Object)this.currentStep);
            return ActionReplayResult.withDifference(ActionReplayData.withoutTarget(this.currentStep, this.stateFilePath), WindowRetriever.empty(), DifferenceRetriever.of(differences), 0L);
        }
        logger.info("Found no differences in step '{}'.", (Object)this.currentStep);
        return ActionReplayResult.withoutDifference(ActionReplayData.withoutTarget(this.currentStep, this.stateFilePath), WindowRetriever.of(check.getCurrentSutState()), 0L);
    }
}

