/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ignore;

import de.retest.recheck.ignore.ShouldIgnore;
import de.retest.recheck.ui.descriptors.Element;
import de.retest.recheck.ui.diff.AttributeDifference;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSShouldIgnoreImpl
implements ShouldIgnore {
    private static final Logger logger = LoggerFactory.getLogger(JSShouldIgnoreImpl.class);
    private static final String JS_ENGINE_NAME = "JavaScript";
    private final ScriptEngine engine;
    private final Set<String> errorFunctions = new HashSet<String>();

    public JSShouldIgnoreImpl(Path ignoreFilePath) {
        ScriptEngineManager manager = new ScriptEngineManager();
        this.engine = manager.getEngineByName(JS_ENGINE_NAME);
        try {
            this.engine.eval(this.readScriptFile(ignoreFilePath));
        }
        catch (Exception e) {
            logger.error("Reading script file '{}' caused exception: ", (Object)ignoreFilePath, (Object)e);
        }
    }

    Reader readScriptFile(Path ignoreFilePath) {
        try {
            logger.info("Reading JS ignore rules file from {}.", (Object)ignoreFilePath);
            return Files.newBufferedReader(ignoreFilePath, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error("Error opening JS file from '{}': ", (Object)ignoreFilePath, (Object)e);
            return new StringReader("");
        }
    }

    @Override
    public boolean shouldIgnoreElement(Element element) {
        return this.callBooleanJSFunction("shouldIgnoreElement", element);
    }

    @Override
    public boolean shouldIgnoreAttributeDifference(Element element, AttributeDifference attributeDifference) {
        return this.callBooleanJSFunction("shouldIgnoreAttributeDifference", element, attributeDifference);
    }

    private boolean callBooleanJSFunction(String functionName, Object ... args) {
        if (this.errorFunctions.contains(functionName)) {
            return false;
        }
        Invocable inv = (Invocable)((Object)this.engine);
        try {
            Object callResult = inv.invokeFunction(functionName, args);
            if (callResult == null) {
                logger.warn("{} returned 'null' instead of a boolean value. Interpreting that as 'false'.", (Object)functionName);
                return false;
            }
            if (!(callResult instanceof Boolean)) {
                logger.error("'{}' of {} cannot be cast to java.lang.Boolean.", callResult, callResult.getClass());
                this.errorFunctions.add(functionName);
            }
            return (Boolean)callResult;
        }
        catch (ScriptException e) {
            logger.error("JS '{}' method caused an exception: {}", (Object)functionName, (Object)e.getMessage());
            this.errorFunctions.add(functionName);
        }
        catch (NoSuchMethodException e) {
            logger.warn("Specified JS ignore file has no '{}' function.", (Object)functionName);
            this.errorFunctions.add(functionName);
        }
        return false;
    }
}

