/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.ignore;

import de.retest.recheck.configuration.ProjectConfigurationUtil;
import de.retest.recheck.review.GlobalIgnoreApplier;
import de.retest.recheck.review.counter.NopCounter;
import de.retest.recheck.review.workers.LoadShouldIgnoreWorker;
import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecheckIgnoreUtil {
    private static final Logger logger = LoggerFactory.getLogger(RecheckIgnoreUtil.class);

    private RecheckIgnoreUtil() {
    }

    public static Optional<Path> getIgnoreFile() {
        return RecheckIgnoreUtil.getRetestFile("recheck.ignore");
    }

    public static Optional<Path> getIgnoreRuleFile() {
        return RecheckIgnoreUtil.getRetestFile("recheck.ignore.js");
    }

    private static Optional<Path> getRetestFile(String filename) {
        Optional<Path> projectConfigurationFolder = ProjectConfigurationUtil.findProjectConfigurationFolder();
        return projectConfigurationFolder.map(p -> p.resolve(filename));
    }

    public static GlobalIgnoreApplier loadRecheckIgnore() {
        try {
            LoadShouldIgnoreWorker loadShouldIgnoreWorker = new LoadShouldIgnoreWorker(NopCounter.getInstance());
            return loadShouldIgnoreWorker.load();
        }
        catch (Exception e) {
            logger.error("Could not load recheck ignore file.", (Throwable)e);
            return GlobalIgnoreApplier.create(NopCounter.getInstance());
        }
    }
}

