/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.image;

import de.retest.recheck.image.ImageDifference;
import de.retest.recheck.image.ImageDifferenceCalculator;
import de.retest.recheck.ui.image.ImageUtils;
import de.retest.recheck.ui.image.Screenshot;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ExactImageDifferenceCalculator
implements ImageDifferenceCalculator {
    public ImageDifference compare(String file1, String file2) throws IOException {
        return this.compare(ImageUtils.readImage(file1), ImageUtils.readImage(file2));
    }

    @Override
    public ImageDifference compare(Screenshot shot1, Screenshot shot2) {
        return this.compare(ImageUtils.screenshot2Image(shot1), ImageUtils.screenshot2Image(shot2));
    }

    @Override
    public ImageDifference compare(BufferedImage img1, BufferedImage img2) {
        if (img1 == null) {
            if (img2 == null) {
                return new ImageDifference(1.0, null, ExactImageDifferenceCalculator.class);
            }
            return new ImageDifference(0.0, img2, ExactImageDifferenceCalculator.class);
        }
        if (img2 == null) {
            return new ImageDifference(0.0, img1, ExactImageDifferenceCalculator.class);
        }
        img1 = ImageUtils.toBufferedImage(ImageUtils.scaleToSameSize(img1, img2));
        img2 = ImageUtils.toBufferedImage(ImageUtils.scaleToSameSize(img2, img1));
        int w = img1.getWidth();
        int h = img1.getHeight();
        int highlight = Color.MAGENTA.getRGB();
        int[] p1 = img1.getRGB(0, 0, w, h, null, 0, w);
        int[] p2 = img2.getRGB(0, 0, w, h, null, 0, w);
        int diffTotal = 0;
        for (int i = 0; i < p1.length; ++i) {
            if (p1[i] == p2[i]) continue;
            p1[i] = highlight;
            ++diffTotal;
        }
        BufferedImage out = new BufferedImage(w, h, 1);
        out.setRGB(0, 0, w, h, p1, 0, w);
        return new ImageDifference((double)(p1.length - diffTotal) / (double)p1.length, out, ExactImageDifferenceCalculator.class);
    }
}

