/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.image;

import de.retest.recheck.image.ImageDifference;
import de.retest.recheck.image.ImageDifferenceCalculator;
import de.retest.recheck.ui.image.ImageUtils;
import de.retest.recheck.ui.image.Screenshot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import javax.swing.GrayFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuzzyImageDifferenceCalculator
implements ImageDifferenceCalculator {
    private static final Logger logger = LoggerFactory.getLogger(FuzzyImageDifferenceCalculator.class);
    private static final int BLOCKSIZE = 10;
    private static final int SENSITIVITY = 3;
    private static final double STABILIZER = 25.0;

    public ImageDifference compare(String file1, String file2) throws IOException {
        return this.compare(ImageUtils.readImage(file1), ImageUtils.readImage(file2));
    }

    @Override
    public ImageDifference compare(Screenshot shot1, Screenshot shot2) {
        return this.compare(ImageUtils.screenshot2Image(shot1), ImageUtils.screenshot2Image(shot2));
    }

    @Override
    public ImageDifference compare(BufferedImage img1, BufferedImage img2) {
        if (img1 == null) {
            if (img2 == null) {
                return new ImageDifference(1.0, null, FuzzyImageDifferenceCalculator.class);
            }
            return new ImageDifference(0.0, img2, FuzzyImageDifferenceCalculator.class);
        }
        if (img2 == null) {
            return new ImageDifference(0.0, img1, FuzzyImageDifferenceCalculator.class);
        }
        img1 = ImageUtils.toBufferedImage(ImageUtils.scaleProportionallyToMaxWidthHeight(img1, 800, 600));
        img1 = ImageUtils.toBufferedImage(ImageUtils.scaleToSameSize(img1, img2));
        img2 = ImageUtils.toBufferedImage(ImageUtils.scaleToSameSize(img2, img1));
        BufferedImage differenceImage = ImageUtils.toBufferedImage(img2);
        Graphics2D gc = differenceImage.createGraphics();
        gc.setColor(Color.RED);
        img1 = ImageUtils.toBufferedImage(GrayFilter.createDisabledImage(img1));
        img2 = ImageUtils.toBufferedImage(GrayFilter.createDisabledImage(img2));
        int numdiffs = 0;
        int numRows = (int)Math.ceil((float)img1.getHeight() / 10.0f);
        int numCols = (int)Math.ceil((float)img1.getWidth() / 10.0f);
        StringBuilder textual = new StringBuilder();
        for (int row = 0; row < numRows; ++row) {
            textual.append("|");
            for (int col = 0; col < numCols; ++col) {
                int b2;
                int b1 = this.getAverageBrightness(this.getSubImage(img1, col, row));
                int diff = Math.abs(b1 - (b2 = this.getAverageBrightness(this.getSubImage(img2, col, row))));
                if (diff > 3) {
                    gc.drawRect(col * 10, row * 10, 9, 9);
                    ++numdiffs;
                }
                textual.append(diff > 3 ? "X" : " ");
            }
            textual.append("|");
            logger.warn(textual.toString());
            textual = new StringBuilder();
        }
        if (numdiffs == 0) {
            return new ImageDifference(1.0, differenceImage, FuzzyImageDifferenceCalculator.class);
        }
        int total = numRows * numCols;
        double match = (double)(total - numdiffs) / (double)total;
        return new ImageDifference(match, differenceImage, FuzzyImageDifferenceCalculator.class);
    }

    protected int getAverageBrightness(BufferedImage img) {
        Raster r = img.getData();
        int total = 0;
        for (int y = 0; y < r.getHeight(); ++y) {
            for (int x = 0; x < r.getWidth(); ++x) {
                total += r.getSample(r.getMinX() + x, r.getMinY() + y, 0);
            }
        }
        return (int)((double)total / ((double)r.getWidth() / 25.0 * ((double)r.getHeight() / 25.0)));
    }

    private BufferedImage getSubImage(BufferedImage img, int col, int row) {
        int x = col * 10;
        int width = Math.abs(Math.min(img.getWidth() - x, 9));
        int y = row * 10;
        int height = Math.abs(Math.min(img.getHeight() - y, 9));
        return img.getSubimage(x, y, width, height);
    }
}

