/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.image;

import de.retest.recheck.image.ExactImageDifferenceCalculator;
import de.retest.recheck.image.ImageDifferenceCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageDiffCalcFactory {
    private static final Logger logger = LoggerFactory.getLogger(ImageDiffCalcFactory.class);
    private static final String IMAGE_DIFFERENCE_CALCULATOR = "de.retest.image.DifferenceCalculator";

    private ImageDiffCalcFactory() {
    }

    public static ImageDifferenceCalculator getConfiguredImageDifferenceCalculator() {
        String configured = System.getProperty(IMAGE_DIFFERENCE_CALCULATOR);
        if (configured != null) {
            try {
                return (ImageDifferenceCalculator)Class.forName(configured).newInstance();
            }
            catch (Exception exc) {
                logger.error("Error creating configured ImageDifferenceCalculator {}:", (Object)configured, (Object)exc);
            }
        }
        return new ExactImageDifferenceCalculator();
    }
}

