/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence;

import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateAdapter
extends XmlAdapter<String, Date> {
    private static final FastDateFormat defaultDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssZZ", (TimeZone)TimeZone.getTimeZone("UTC"));
    private static final FastDateFormat[] possibleDateFormats = new FastDateFormat[]{defaultDateFormat, FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss Z"), FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ"), FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ")};

    public String marshal(Date value) {
        if (value == null) {
            return null;
        }
        return defaultDateFormat.format(value);
    }

    public Date unmarshal(String value) {
        if (value == null) {
            return null;
        }
        for (FastDateFormat dateFormat : possibleDateFormats) {
            try {
                return dateFormat.parse(value);
            }
            catch (ParseException parseException) {
            }
        }
        throw new RuntimeException("Can't parse date '" + value + "'!");
    }
}

