/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence;

import de.retest.recheck.Properties;
import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.persistence.Persistence;
import de.retest.recheck.persistence.bin.KryoPersistence;
import de.retest.recheck.persistence.xml.XmlFolderPersistence;
import de.retest.recheck.persistence.xml.XmlTransformer;
import de.retest.recheck.persistence.xml.XmlZipPersistence;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class PersistenceFactory {
    private final XmlTransformer xml;

    public PersistenceFactory(Set<Class<?>> xmlDataClasses) {
        this.xml = new XmlTransformer(xmlDataClasses);
    }

    public PersistenceFactory(XmlTransformer xml) {
        this.xml = xml;
    }

    public <T extends Persistable> Persistence<T> getPersistence() {
        return new DynamicLoadPersistenceProxy();
    }

    <T extends Persistable> Persistence<T> getSavePersistenceForIdentifier(URI identifier) {
        Properties.FileOutputFormat format = this.getFormatForIdentifier(identifier);
        switch (format) {
            case ZIP: {
                return new XmlZipPersistence(this.xml);
            }
            case PLAIN: {
                return new XmlFolderPersistence(this.xml);
            }
            case KRYO: {
                return new KryoPersistence();
            }
        }
        throw new RuntimeException("Unexpected FileOutputFormat: " + (Object)((Object)Properties.getFileOutputFormat()));
    }

    <T extends Persistable> Persistence<T> getLoadPersistenceForIdentifier(URI identifier) {
        Properties.FileOutputFormat format = this.getFormatForIdentifier(identifier);
        if (format == Properties.FileOutputFormat.KRYO) {
            return new KryoPersistence();
        }
        if (new File(identifier).isDirectory()) {
            return new XmlFolderPersistence(this.xml);
        }
        return new XmlZipPersistence(this.xml);
    }

    private Properties.FileOutputFormat getFormatForIdentifier(URI identifier) {
        String filename = FilenameUtils.getName((String)identifier.getPath());
        if (filename.endsWith(".result")) {
            return Properties.FileOutputFormat.KRYO;
        }
        return Properties.getFileOutputFormat();
    }

    class DynamicLoadPersistenceProxy<T extends Persistable>
    implements Persistence<T> {
        DynamicLoadPersistenceProxy() {
        }

        @Override
        public void save(URI identifier, T element) throws IOException {
            Persistence<T> p = PersistenceFactory.this.getSavePersistenceForIdentifier(identifier);
            p.save(identifier, element);
        }

        @Override
        public T load(URI identifier) throws IOException {
            Persistence p = PersistenceFactory.this.getLoadPersistenceForIdentifier(identifier);
            return p.load(identifier);
        }
    }
}

