/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence;

import de.retest.recheck.configuration.ProjectRootFinderUtil;
import de.retest.recheck.persistence.NoStateFileFoundException;
import de.retest.recheck.persistence.Persistence;
import de.retest.recheck.persistence.RecheckStateFileProvider;
import de.retest.recheck.ui.descriptors.SutState;
import de.retest.recheck.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecheckStateFileProviderImpl
implements RecheckStateFileProvider {
    public static final String RECHECK_PROJECT_ROOT = "de.retest.recheck.root";
    private static final Logger logger = LoggerFactory.getLogger(RecheckStateFileProviderImpl.class);
    private final Persistence<SutState> persistence;

    public RecheckStateFileProviderImpl(Persistence<SutState> persistence) {
        this.persistence = persistence;
    }

    @Override
    public File getRecheckStateFile(String filePath) throws NoStateFileFoundException {
        Path projectRoot = ProjectRootFinderUtil.getProjectRoot().orElseThrow(() -> new NoStateFileFoundException(filePath));
        Path projectRootStates = this.getStates(projectRoot, filePath);
        if (projectRootStates != null) {
            return projectRootStates.toFile();
        }
        throw new NoStateFileFoundException(filePath);
    }

    private Path getStates(Path projectRoot, String filePath) {
        if (projectRoot != null && filePath != null) {
            logger.debug("Looking for SUT state files in '{}'.", (Object)projectRoot);
            Path statePath = Paths.get(projectRoot.toAbsolutePath().toString(), filePath);
            if (statePath.toFile().exists()) {
                return statePath.toAbsolutePath();
            }
        }
        return null;
    }

    @Override
    public SutState loadRecheckState(File file) {
        SutState result;
        try {
            result = this.persistence.load(file.toURI());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not load SUT state from file '" + FileUtil.canonicalPathQuietly(file) + "'.", e);
        }
        if (result == null) {
            throw new NullPointerException("Loaded SUT state from file " + FileUtil.canonicalPathQuietly(file) + "' is null.");
        }
        return result;
    }

    @Override
    public void saveRecheckState(File file, SutState state) {
        String canonicalPathQuietly = FileUtil.canonicalPathQuietly(file);
        try {
            this.persistence.save(file.toURI(), state);
            logger.info("Updated SUT state file {}.", (Object)canonicalPathQuietly);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not apply changes to SUT state file '" + canonicalPathQuietly + "'.", e);
        }
    }
}

