/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence;

import de.retest.recheck.RecheckAdapter;
import de.retest.recheck.XmlTransformerUtil;
import de.retest.recheck.persistence.PersistenceFactory;
import de.retest.recheck.ui.descriptors.RootElement;
import de.retest.recheck.ui.descriptors.SutState;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Set;

public class RecheckSutState {
    private static final PersistenceFactory persistenceFactory = new PersistenceFactory(XmlTransformerUtil.getXmlTransformer());

    private RecheckSutState() {
    }

    public static SutState convert(Object toVerify, RecheckAdapter adapter) {
        Set<RootElement> converted = adapter.convert(toVerify);
        if (converted == null || converted.isEmpty()) {
            throw new IllegalStateException("Cannot check empty state!");
        }
        return new SutState(converted);
    }

    public static SutState createNew(File file, SutState actual) {
        try {
            persistenceFactory.getPersistence().save(file.toURI(), actual);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not save sut state '" + actual + "' to '" + file + "'.", e);
        }
        return new SutState(new ArrayList<RootElement>());
    }

    public static SutState loadExpected(File file) {
        if (!file.exists()) {
            return null;
        }
        if (!new File(file, "retest.xml").exists()) {
            return null;
        }
        try {
            return (SutState)persistenceFactory.getPersistence().load(file.toURI());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not load sut state from '" + file + "'.", e);
        }
    }
}

