/*
 * Decompiled with CFR 0.152.
 */
package de.retest.recheck.persistence.bin;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.TreeMultiset;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import de.retest.recheck.persistence.Persistable;
import de.retest.recheck.persistence.Persistence;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class KryoPersistence<T extends Persistable>
implements Persistence<T> {
    private final Kryo kryo = this.createKryo();

    private Kryo createKryo() {
        Kryo kryo = new Kryo();
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        Registration registration = kryo.getRegistration(TreeMultiset.class);
        registration.setInstantiator(TreeMultiset::create);
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
        return kryo;
    }

    @Override
    public void save(URI identifier, T element) throws IOException {
        try (Output output = new Output(Files.newOutputStream(Paths.get(identifier), new OpenOption[0]));){
            this.kryo.writeClassAndObject(output, element);
        }
    }

    @Override
    public T load(URI identifier) throws IOException {
        try (Input input = new Input(Files.newInputStream(Paths.get(identifier), new OpenOption[0]));){
            Persistable persistable = (Persistable)this.kryo.readClassAndObject(input);
            return (T)persistable;
        }
    }
}

